/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONFIGFILEOLD_H
#define CONFIGFILEOLD_H

class ConfigFile;

#include <qstring.h>

#include "AudioConfig.h"
#include "HVSC_Config.h"
#include "MixerConfig.h"
#include "tools/TextFile.h"
#include "wrapper/emucfg.h"

class MiscConfig
{
 public:
    int cfgFileVersion;
    
    long int usage;  // listening mileage in seconds
    
    bool enableStilView;
    
    bool enableSongLenDB;
    int playtimeDef, fadeoutDef;
    QString playlistDir;
    
    QString currentDir;
    QString nameFilter;
    bool showDirDlg;
    
    struct Geom
    {
        int x,y,w,h;
        Geom()
        {
            x = y = w = h = 0;
        }
    };
    
    Geom geomDirDlg;
    Geom geomMainDlg;
    Geom geomPlaylistDlg;
    
    MixerConfig myMixerConfig;
    
    MiscConfig()
    {
        cfgFileVersion = 0;
        usage = 0;
        
        enableStilView = false;
        
        enableSongLenDB = false;
        playtimeDef = fadeoutDef = 0;
        playlistDir = ".";
        
        currentDir = ".";
        nameFilter = "*.sid";
        showDirDlg = false;
    }
};

class ConfigFileOld : private TextFile
{
 public:
    ConfigFileOld(const char*);

    bool load();
    void convertToIni(ConfigFile*);
    
    void setEmuConfig(const emuConfig& inEmuConfig)  { myEmuConfig = inEmuConfig; }
    
 private:  // disable obsolete functions
    bool save();
    
    const emuConfig& getEmuConfig() const  { return myEmuConfig; }
    const AudioConfig& getAudioConfig() const  { return myAudioConfig; }
    const HVSC_Config& getHVSC_Config() const  { return myHVSC_Config; }
    const MiscConfig& getMiscConfig() const  { return myConfig; }

    void setAudioConfig(const AudioConfig& inAudioConfig)  { myAudioConfig = inAudioConfig; }
    void setHVSC_Config(const HVSC_Config& inHVSC_Config)  { myHVSC_Config = inHVSC_Config; }
    void setMiscConfig(const MiscConfig& inConfig)  { myConfig = inConfig; }

 protected:
    AudioConfig myAudioConfig;  // the audio driver settings
    emuConfig myEmuConfig;      // the emulator engine settings
    HVSC_Config myHVSC_Config;  // the HVSC/STIL settings
    MiscConfig myConfig;        // everything else
    
 private:
    void writeBoolKey(ofstream& toFile, const char* key, const bool flag);
    
    QString fileName;
};

#endif  /* CONFIGFILEOLD_H */
