/** @file perl/except.i
 * @brief Custom Perl exception handling.
 */
/* Warning: This file is generated by ./generate-perl-exceptions
 * - do not modify directly!
 *
 * Copyright (C) 2003,2004,2006,2007,2008,2011,2012,2013 Olly Betts
 * Copyright (C) 2007 Lemur Consulting Ltd
 * Copyright (C) 2007 Richard Boulton
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

namespace Xapian {

%exceptionclass Error;
%exceptionclass LogicError;
%exceptionclass RuntimeError;
%exceptionclass AssertionError;
%exceptionclass InvalidArgumentError;
%exceptionclass InvalidOperationError;
%exceptionclass UnimplementedError;
%exceptionclass DatabaseError;
%exceptionclass DatabaseCorruptError;
%exceptionclass DatabaseCreateError;
%exceptionclass DatabaseLockError;
%exceptionclass DatabaseModifiedError;
%exceptionclass DatabaseOpeningError;
%exceptionclass DatabaseVersionError;
%exceptionclass DocNotFoundError;
%exceptionclass FeatureUnavailableError;
%exceptionclass InternalError;
%exceptionclass NetworkError;
%exceptionclass NetworkTimeoutError;
%exceptionclass QueryParserError;
%exceptionclass SerialisationError;
%exceptionclass RangeError;
%exceptionclass WildcardError;
%exceptionclass DatabaseNotFoundError;
%exceptionclass DatabaseClosedError;
}
%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception() {
    try {
	throw;
    } catch (const Xapian::DatabaseClosedError &e) {
	void * p = (void *) new Xapian::DatabaseClosedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseClosedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseClosedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseClosedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseNotFoundError &e) {
	void * p = (void *) new Xapian::DatabaseNotFoundError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseNotFoundError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseNotFoundError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseNotFoundError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::WildcardError &e) {
	void * p = (void *) new Xapian::WildcardError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::WildcardError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::WildcardError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::WildcardError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::RangeError &e) {
	void * p = (void *) new Xapian::RangeError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::RangeError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::RangeError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::RangeError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::SerialisationError &e) {
	void * p = (void *) new Xapian::SerialisationError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::SerialisationError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::SerialisationError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::SerialisationError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::QueryParserError &e) {
	void * p = (void *) new Xapian::QueryParserError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::QueryParserError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::QueryParserError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::QueryParserError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::NetworkTimeoutError &e) {
	void * p = (void *) new Xapian::NetworkTimeoutError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::NetworkTimeoutError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::NetworkTimeoutError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::NetworkTimeoutError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::NetworkError &e) {
	void * p = (void *) new Xapian::NetworkError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::NetworkError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::NetworkError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::NetworkError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InternalError &e) {
	void * p = (void *) new Xapian::InternalError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InternalError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InternalError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InternalError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::FeatureUnavailableError &e) {
	void * p = (void *) new Xapian::FeatureUnavailableError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::FeatureUnavailableError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::FeatureUnavailableError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::FeatureUnavailableError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DocNotFoundError &e) {
	void * p = (void *) new Xapian::DocNotFoundError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DocNotFoundError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DocNotFoundError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DocNotFoundError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseVersionError &e) {
	void * p = (void *) new Xapian::DatabaseVersionError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseVersionError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseVersionError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseVersionError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseOpeningError &e) {
	void * p = (void *) new Xapian::DatabaseOpeningError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseOpeningError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseOpeningError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseOpeningError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseModifiedError &e) {
	void * p = (void *) new Xapian::DatabaseModifiedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseModifiedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseModifiedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseModifiedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseLockError &e) {
	void * p = (void *) new Xapian::DatabaseLockError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseLockError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseLockError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseLockError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseCreateError &e) {
	void * p = (void *) new Xapian::DatabaseCreateError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseCreateError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseCreateError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseCreateError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseCorruptError &e) {
	void * p = (void *) new Xapian::DatabaseCorruptError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseCorruptError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseCorruptError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseCorruptError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseError &e) {
	void * p = (void *) new Xapian::DatabaseError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::UnimplementedError &e) {
	void * p = (void *) new Xapian::UnimplementedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::UnimplementedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::UnimplementedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::UnimplementedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InvalidOperationError &e) {
	void * p = (void *) new Xapian::InvalidOperationError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InvalidOperationError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InvalidOperationError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InvalidOperationError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InvalidArgumentError &e) {
	void * p = (void *) new Xapian::InvalidArgumentError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InvalidArgumentError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InvalidArgumentError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InvalidArgumentError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::AssertionError &e) {
	void * p = (void *) new Xapian::AssertionError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::AssertionError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::AssertionError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::AssertionError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::RuntimeError &e) {
	void * p = (void *) new Xapian::RuntimeError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::RuntimeError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::RuntimeError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::RuntimeError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::LogicError &e) {
	void * p = (void *) new Xapian::LogicError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::LogicError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::LogicError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::LogicError", p);
	croak(Nullch);
#endif
    } catch (const std::exception& e) {
	croak("std::exception: %s", e.what());
    } catch (...) {
	croak("something terrible happened");
    }
}
}
%}

/* Functions and methods which are marked as "nothrow": */
%exception Xapian::Compactor::get_constinfo_();
%exception Xapian::Database::postlist_end(const std::string &) const;
%exception Xapian::Database::termlist_end(Xapian::docid) const;
%exception Xapian::Database::positionlist_end(Xapian::docid, const std::string &) const;
%exception Xapian::Database::allterms_end(const std::string & = std::string()) const;
%exception Xapian::Database::valuestream_end(Xapian::valueno) const;
%exception Xapian::Database::spellings_end() const;
%exception Xapian::Database::synonyms_end(const std::string &) const;
%exception Xapian::Database::synonym_keys_end(const std::string & = std::string()) const;
%exception Xapian::Database::metadata_keys_end(const std::string & = std::string()) const;
%exception Xapian::Document::termlist_end() const;
%exception Xapian::Document::values_end() const;
%exception Xapian::Enquire::get_matching_terms_end(Xapian::docid  ) const;
%exception Xapian::Enquire::get_matching_terms_end(const MSetIterator & ) const;
%exception Xapian::Error::get_type() const;
%exception Xapian::Error::get_msg() const;
%exception Xapian::Error::get_context() const;
%exception Xapian::ErrorHandler::ErrorHandler();
%exception Xapian::ESetIterator::operator==(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator!=(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator<(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator>(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator>=(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ESetIterator::operator<=(const ESetIterator &a, const ESetIterator &b);
%exception Xapian::ExpandDeciderFilterPrefix::miles_to_metres(double miles);
%exception Xapian::ExpandDeciderFilterPrefix::metres_to_miles(double metres);
%exception Xapian::ExpandDeciderFilterPrefix::LatLongCoord();
%exception Xapian::ExpandDeciderFilterPrefix::operator<(const LatLongCoord & other) const;
%exception Xapian::MatchSpy::MatchSpy();
%exception Xapian::ValueCountMatchSpy::get_total() const;
%exception Xapian::ValueCountMatchSpy::values_end() const;
%exception Xapian::ValueCountMatchSpy::top_values_end(size_t) const;
%exception Xapian::MSetIterator::operator==(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::MSetIterator::operator!=(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::MSetIterator::operator<(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::MSetIterator::operator>(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::MSetIterator::operator>=(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::MSetIterator::operator<=(const MSetIterator &a, const MSetIterator &b);
%exception Xapian::PositionIterator::PositionIterator();
%exception Xapian::PositionIterator::operator==(const PositionIterator &a, const PositionIterator &b);
%exception Xapian::PositionIterator::operator!=(const PositionIterator &a, const PositionIterator &b);
%exception Xapian::PostingIterator::PostingIterator();
%exception Xapian::PostingIterator::positionlist_end() const;
%exception Xapian::PostingIterator::operator==(const PostingIterator &a, const PostingIterator &b);
%exception Xapian::PostingIterator::operator!=(const PostingIterator &a, const PostingIterator &b);
%exception Xapian::PostingSource::PostingSource();
%exception Xapian::PostingSource::get_maxweight() const;
%exception Xapian::Query::Query();
%exception Xapian::Query::get_terms_end() const;
%exception Xapian::Query::get_unique_terms_end() const;
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::empty() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Query::Internal();
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::QueryParser::stoplist_end() const;
%exception Xapian::QueryParser::unstem_end(const std::string &) const;
%exception Xapian::QueryParser::sortable_serialise_(double value, char * buf);
%exception Xapian::QueryParser::sortable_unserialise(const std::string & serialised);
%exception Xapian::TermIterator::TermIterator();
%exception Xapian::TermIterator::positionlist_end() const;
%exception Xapian::TermIterator::operator==(const TermIterator &a, const TermIterator &b);
%exception Xapian::TermIterator::operator!=(const TermIterator &a, const TermIterator &b);
%exception Xapian::Utf8Iterator::calculate_sequence_length() const;
%exception Xapian::Utf8Iterator::Utf8Iterator();
%exception Xapian::Utf8Iterator::operator*() const;
%exception Xapian::Utf8Iterator::strict_deref() const;
%exception Xapian::Utf8Iterator::operator==(const Utf8Iterator &other) const;
%exception Xapian::Utf8Iterator::operator!=(const Utf8Iterator &other) const;
%exception Xapian::Utf8Iterator::get_character_info(unsigned ch);
%exception Xapian::ValueIterator::ValueIterator();
%exception Xapian::ValueIterator::operator==(const ValueIterator &a, const ValueIterator &b);
%exception Xapian::ValueIterator::operator!=(const ValueIterator &a, const ValueIterator &b);

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception();
	SWIG_fail;
    }
}
