#!/bin/sh
# -*- coding: latin-1 -*-
cat > debian/copyright << EOF
Format: http://dep.debian.net/deps/dep5
Upstream-Name: wims
Source: sent in a private e-mail by Antonio Ulln <aullan@unex.es>

Files: *
Copyright: 2007-2008      Juan Rafael Fernndez <jrfern@gmail.com>
           2008-2009      Antonio Ulln <aullan@unex.es>
License: GPL-2+

EOF

(
    for f in $(find modules/ -type f -name INDEX | LC_ALL=C sort); do 
	echo  "Files: $(dirname $f)/*";
	year=$(grep COPYING $f | sed 's/.*&copy; \(\S*\) .*/\1/');
	author=$(grep author $f  | sed 's/author=\(.*\)/\1/');
	author_email=$(grep address $f| grep -v translator| sed 's/address=\(.*\)/\1/');
	echo "Copyright: $year, $author <${author_email}>"
	translator=$(grep translator $f| grep -v address  | sed 's/translator=\(.*\)/\1/');
	translator_email=$(grep translator_address $f| sed 's/translator_address=\(.*\)/\1/');
	translator_year=$(ls -l $f| awk '{print $8}')
	if [ -n "$translator" ]; then
	    echo "           ${translator_year}, ${translator} (translator) <${translator_email}>"
	fi
	echo "License: GPL-2+"
	echo
    done
) >> debian/copyright

cat >> debian/copyright <<EOF
Files: debian/*
Copyright: 2006-2015 Georges Khaznadar <georgesk@debian.org>
License: GPL-2+

License: GPL-2+
 This package is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 .
 This package is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 .
 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>
 .
 On Debian systems, the complete text of the GNU General
 Public License version 2 can be found in "/usr/share/common-licenses/GPL-2".
EOF
recode latin1..utf8 debian/copyright
