/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import javax.vecmath.Point3d;
import org.j3d.util.interpolator.Interpolator;

class PositionInterpolator
extends Interpolator {
    private Point3d sharedPoint;
    private double[] sharedVector;
    private double[][] keyValues;

    PositionInterpolator() {
        this(20);
    }

    PositionInterpolator(int n) {
        super(n, 1);
        this.keys = new float[n];
        this.keyValues = new double[n][3];
        this.sharedPoint = new Point3d();
        this.sharedVector = new double[3];
    }

    void addKeyFrame(float f, double d, double d2, double d3) {
        double[] dArray;
        int n = this.findKeyIndex(f);
        if (n < 0) {
            n = 0;
        }
        while (n < this.currentSize && this.keys[n] <= f) {
            ++n;
        }
        this.realloc();
        if (n >= this.currentSize) {
            dArray = this.keyValues[this.currentSize];
        } else {
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            dArray = new double[3];
            this.keyValues[n] = dArray;
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        this.keys[n] = f;
        ++this.currentSize;
    }

    void addKeyFrame(float f, Point3d point3d) {
        this.addKeyFrame(f, point3d.x, point3d.y, point3d.z);
    }

    Point3d pointValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedPoint.set(this.keyValues[0]);
        } else if (n >= this.currentSize - 1) {
            this.sharedPoint.set(this.keyValues[this.currentSize - 1]);
        } else {
            double[] dArray = this.keyValues[n + 1];
            double[] dArray2 = this.keyValues[n];
            double d = dArray[0] - dArray2[0];
            double d2 = dArray[1] - dArray2[1];
            double d3 = dArray[2] - dArray2[2];
            float f2 = 0.0f;
            float f3 = this.keys[n + 1];
            float f4 = this.keys[n];
            if (f3 != f4) {
                f2 = (f - f4) / (f3 - f4);
            }
            this.sharedPoint.x = dArray2[0] + (double)f2 * d;
            this.sharedPoint.y = dArray2[1] + (double)f2 * d2;
            this.sharedPoint.z = dArray2[2] + (double)f2 * d3;
        }
        return this.sharedPoint;
    }

    double[] floatValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedVector[0] = this.keyValues[0][0];
            this.sharedVector[1] = this.keyValues[0][1];
            this.sharedVector[2] = this.keyValues[0][2];
        } else if (n >= this.currentSize - 1) {
            this.sharedVector[0] = this.keyValues[this.currentSize - 1][0];
            this.sharedVector[1] = this.keyValues[this.currentSize - 1][1];
            this.sharedVector[2] = this.keyValues[this.currentSize - 1][2];
        } else {
            double[] dArray = this.keyValues[n + 1];
            double[] dArray2 = this.keyValues[n];
            double d = dArray[0] - dArray2[0];
            double d2 = dArray[1] - dArray2[1];
            double d3 = dArray[2] - dArray2[2];
            float f2 = 0.0f;
            float f3 = this.keys[n + 1];
            float f4 = this.keys[n];
            if (f3 != f4) {
                f2 = (f - f4) / (f3 - f4);
            }
            this.sharedVector[0] = dArray2[0] + (double)f2 * d;
            this.sharedVector[1] = dArray2[1] + (double)f2 * d2;
            this.sharedVector[2] = dArray2[2] + (double)f2 * d3;
        }
        return this.sharedVector;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            double[][] dArrayArray = new double[n][];
            System.arraycopy(this.keyValues, 0, dArrayArray, 0, this.allocatedSize);
            for (int i = this.allocatedSize; i < n; ++i) {
                dArrayArray[i] = new double[3];
            }
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = dArrayArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<position interpolator>\n");
        for (int i = 0; i < this.currentSize; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(" x: ");
            stringBuffer.append(this.keyValues[i][0]);
            stringBuffer.append(" y: ");
            stringBuffer.append(this.keyValues[i][1]);
            stringBuffer.append(" z: ");
            stringBuffer.append(this.keyValues[i][2]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</position interpolator>");
        return stringBuffer.toString();
    }
}

