"============================================================================
"File:        typescript/tslint.vim
"Description: TypeScript linter
"Maintainer:  Seon-Wook Park <seon.wook@swook.net>
"============================================================================

if exists("g:loaded_syntastic_typescript_tslint_checker")
    finish
endif
let g:loaded_syntastic_typescript_tslint_checker = 1

let s:save_cpo = &cpo
set cpo&vim

function! SyntaxCheckers_typescript_tslint_GetHighlightRegex(item)
    let term = matchstr(a:item['text'], "\\m\\s'\\zs.\\{-}\\ze'\\s")
    return term != '' ? '\V' . escape(term, '\') : ''
endfunction

function! SyntaxCheckers_typescript_tslint_GetLocList() dict
    let makeprg = self.makeprgBuild({
        \ 'args_after': '--format verbose',
        \ 'fname_before': '-f' })

    " (comment-format) ts/app.ts[12, 36]: comment must start with lowercase letter
    let errorformat = '%f[%l\, %c]: %m'

    let loclist = SyntasticMake({
        \ 'makeprg': makeprg,
        \ 'errorformat': errorformat,
        \ 'preprocess': 'tslint',
        \ 'returns': [0, 2] })

    call self.setWantSort(1)

    return loclist
endfunction

call g:SyntasticRegistry.CreateAndRegisterChecker({
    \ 'filetype': 'typescript',
    \ 'name': 'tslint'})

let &cpo = s:save_cpo
unlet s:save_cpo

" vim: set et sts=4 sw=4:
