Uutf — Non-blocking streaming Unicode codec for OCaml
-------------------------------------------------------------------------------
v1.0.1

Uutf is a non-blocking streaming codec to decode and encode the UTF-8,
UTF-16, UTF-16LE and UTF-16BE encoding schemes. It can efficiently
work character by character without blocking on IO. Decoders perform
character position tracking and support newline normalization.

Functions are also provided to fold over the characters of UTF encoded
OCaml string values and to directly encode characters in OCaml
Buffer.t values.

Uutf has no dependency and is distributed under the ISC license.

Home page: http://erratique.ch/software/uutf  
Contact: Daniel Bünzli `<daniel.buenzl i@erratique.ch>`


## Installation

Uutf can be installed with `opam`:

    opam install uutf

If you don't use `opam` consult the [`opam`](opam) file for build
instructions.


## Documentation

The documentation and API reference is automatically generated by from
the source interfaces. It can be consulted [online][doc] or via
`odig doc uutf`.

[doc]: http://erratique.ch/software/uutf/doc/Uutf


## Sample programs

Sample programs are located in the `test` directory of the
distribution. They can be built and run with:

    topkg build --test true && topkg test

The resulting binaries are in `_build/test` :

- `test.native` tests the library, nothing should fail.
- `utftrip.native`, among other things, reads unicode on `stdin` and rewrites 
  it on `stdout`. Invoke with `--help` for more information. Depends
  on [Cmdliner](http://erratique.ch/software/cmdliner).
