/*
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
#ifndef REGEX_HELPER_H
#define REGEX_HELPER_H

#include <pcre.h>

#include <string>


const int OVECCOUNT = 30; // We support $1 - $9 only, and this needs to be 3x that

class regexHelper
{
public:
    regexHelper():
        regex(NULL),regexExtra(NULL),regexCcount(0)
    {

    }

  ~regexHelper()
  {
      if (regex)
          pcre_free(regex);

      if (regexExtra)
          pcre_free(regexExtra);
  }



bool setRegexMatch(const std::string &s);
const std::string& getRegexString() const;
int getRegexCcount() const;
int regexMatch(const char*,int,int ovector[]) const;

private:
  pcre* regex;
  pcre_extra* regexExtra;
  std::string regexString;
  int regexCcount;

};


#endif
