'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH radiobutton n 4.4 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
radiobutton \- Create and manipulate 'radiobutton' pick-one widgets
.SH SYNOPSIS
\fBradiobutton\fR \fIpathName \fR?\fIoptions\fR?
.SO
\-activebackground	\-disabledforeground	\-padx
\-activeforeground	\-font	\-pady
\-anchor	\-foreground	\-relief
\-background	\-highlightbackground	\-takefocus
\-bitmap	\-highlightcolor	\-text
\-borderwidth	\-highlightthickness	\-textvariable
\-compound	\-image	\-underline
\-cursor	\-justify	\-wraplength
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-command command Command
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.  The button's global variable (\fB\-variable\fR option) will
be updated before the command is invoked.
.OP \-height height Height
Specifies a desired height for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option is not specified, the button's desired height is computed
from the size of the image or bitmap or text being displayed in it.
.OP \-indicatoron indicatorOn IndicatorOn
Specifies whether or not the indicator should be drawn.  Must be a
proper boolean value.  If false, the \fB\-relief\fR option is
ignored and the widget's relief is always sunken if the widget is
selected and raised otherwise.
.OP \-offrelief offRelief OffRelief
Specifies the relief for the checkbutton when the indicator is not drawn and
the checkbutton is off.  The default value is
.QW raised .
By setting this option to
.QW flat
and setting \fB\-indicatoron\fR to false and \fB\-overrelief\fR to
.QW raised ,
the effect is achieved
of having a flat button that raises on mouse-over and which is
depressed when activated.  This is the behavior typically exhibited by
the Align-Left, Align-Right, and Center radiobuttons on the toolbar of a
word-processor, for example.
.OP \-overrelief overRelief OverRelief
Specifies an alternative relief for the radiobutton, to be used when the
mouse cursor is over the widget.  This option can be used to make
toolbar buttons, by configuring \fB\-relief flat \-overrelief
raised\fR.  If the value of this option is the empty string, then no
alternative relief is used when the mouse cursor is over the radiobutton.
The empty string is the default value.
.OP \-selectcolor selectColor Background
Specifies a background color to use when the button is selected.
If \fBindicatorOn\fR is true then the color is used as the background for
the indicator regardless of the select state.
If \fB\-indicatoron\fR is false, this color is used as the background
for the entire widget, in place of \fB\-background\fR or \fB\-activeBackground\fR,
whenever the widget is selected.
If specified as an empty string then no special color is used for
displaying when the widget is selected.
.OP \-selectimage selectImage SelectImage
Specifies an image to display (in place of the \fB\-image\fR option)
when the radiobutton is selected.
This option is ignored unless the \fB\-image\fR option has been
specified.
.OP \-state state State
Specifies one of three states for the radiobutton:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the radiobutton is displayed using the
\fB\-foreground\fR and \fB\-background\fR options.  The active state is
typically used when the pointer is over the radiobutton.  In active state
the radiobutton is displayed using the \fB\-activeforeground\fR and
\fB\-activebackground\fR options.  Disabled state means that the radiobutton
should be insensitive:  the default bindings will refuse to activate
the widget and will ignore mouse button presses.
In this state the \fB\-disabledforeground\fR and
\fB\-background\fR options determine how the radiobutton is displayed.
.OP \-tristateimage tristateImage TristateImage
Specifies an image to display (in place of the \fB\-image\fR option)
when the radiobutton is selected.
This option is ignored unless the \fB\-image\fR option has been
specified.
.OP \-tristatevalue tristateValue Value
Specifies the value that causes the radiobutton to display the multi-value
selection, also known as the tri-state mode.  Defaults to
.QW "" .
.OP \-value value Value
Specifies value to store in the button's associated variable whenever
this button is selected.
.OP \-variable variable Variable
Specifies the name of a global variable to set whenever this button is
selected.  Changes in this variable also cause the button to select
or deselect itself.
Defaults to the value \fBselectedButton\fR.
.OP \-width width Width
Specifies a desired width for the button.
If an image or bitmap is being displayed in the button, the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option is not specified, the button's desired width is computed
from the size of the image or bitmap or text being displayed in it.
.BE
.SH DESCRIPTION
.PP
The \fBradiobutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a radiobutton widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the radiobutton such as its colors, font,
text, and initial relief.  The \fBradiobutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A radiobutton is a widget that displays a textual string, bitmap or image
and a diamond or circle called an \fIindicator\fR.
If text is displayed, it must all be in a single font, but it
can occupy multiple lines on the screen (if it contains newlines
or if wrapping occurs because of the \fB\-wraplength\fR option) and
one of the characters may optionally be underlined using the
\fB\-underline\fR option.  A radiobutton has
all of the behavior of a simple button: it can display itself in either
of three different ways, according to the \fB\-state\fR option;
it can be made to appear
raised, sunken, or flat; it can be made to flash; and it invokes
a Tcl command whenever mouse button 1 is clicked over the
check button.
.PP
In addition, radiobuttons can be \fIselected\fR.
If a radiobutton is selected, the indicator is normally
drawn with a selected appearance, and
a Tcl variable associated with the radiobutton is set to a particular
value (normally 1).
Under Unix, the indicator is drawn with a sunken relief and a special
color.  Under Windows, the indicator is drawn with a round mark inside.
If the radiobutton is not selected, then the indicator is drawn with a
deselected appearance, and the associated variable is
set to a different value (typically 0).
The indicator is drawn without a round mark inside.
Typically, several radiobuttons share a single variable and the
value of the variable indicates which radiobutton is to be selected.
When a radiobutton is selected it sets the value of the variable to
indicate that fact;  each radiobutton also monitors the value of
the variable and automatically selects and deselects itself when the
variable's value changes.
If the variable's value matches the \fB\-tristatevalue\fR, then the radiobutton
is drawn using the tri-state mode.  This mode is used to indicate mixed or
multiple values.  (This is used when the radiobutton represents the state
of multiple items.)
By default the variable \fBselectedButton\fR
is used;  its contents give the name of the button that is
selected, or the empty string if no button associated with that
variable is selected.
The name of the variable for a radiobutton,
plus the variable to be stored into it, may be modified with options
on the command line or in the option database.
Configuration options may also be used to modify the way the
indicator is displayed (or whether it is displayed at all).
By default a radiobutton is configured to select itself on button clicks.
.SH "WIDGET COMMAND"
.PP
The \fBradiobutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for radiobutton widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
.
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBradiobutton\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
.
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBradiobutton\fR
command.
.TP
\fIpathName \fBdeselect\fR
.
Deselects the radiobutton and sets the associated variable to an
empty string.
If this radiobutton was not currently selected, the command has
no effect.
.TP
\fIpathName \fBflash\fR
.
Flashes the radiobutton.  This is accomplished by redisplaying the radiobutton
several times, alternating between active and normal colors.  At
the end of the flash the radiobutton is left in the same normal/active
state as when the command was invoked.
This command is ignored if the radiobutton's state is \fBdisabled\fR.
.TP
\fIpathName \fBinvoke\fR
.
Does just what would have happened if the user invoked the radiobutton
with the mouse: selects the button and invokes
its associated Tcl command, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the radiobutton.
This command is ignored if the radiobutton's state is \fBdisabled\fR.
.TP
\fIpathName \fBselect\fR
.
Selects the radiobutton and sets the associated variable to the
value corresponding to this widget.
.SH BINDINGS
.PP
Tk automatically creates class bindings for radiobuttons that give them
the following default behavior:
.IP [1]
On Unix systems, a radiobutton activates whenever the mouse passes
over it and deactivates whenever the mouse leaves the radiobutton.  On
Mac and Windows systems, when mouse button 1 is pressed over a
radiobutton, the button activates whenever the mouse pointer is inside
the button, and deactivates whenever the mouse pointer leaves the
button.
.IP [2]
When mouse button 1 is pressed over a radiobutton it is invoked (it
becomes selected and the command associated with the button is
invoked, if there is one).
.IP [3]
When a radiobutton has the input focus, the space key causes the radiobutton
to be invoked.
.PP
If the radiobutton's state is \fBdisabled\fR then none of the above
actions occur:  the radiobutton is completely non-responsive.
.PP
The behavior of radiobuttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.SH "SEE ALSO"
checkbutton(n), labelframe(n), listbox(n), options(n), scale(n), ttk::radiobutton(n)
.SH KEYWORDS
radiobutton, widget
'\" Local Variables:
'\" mode: nroff
'\" End:
