/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sf;

import net.tinyos.sf.SFRenderer;

public class SFConsoleRenderer
implements SFRenderer {
    boolean statusLine = false;
    boolean listening = false;
    int nclients = 0;
    int nread = 0;
    int nwritten = 0;

    public void SFConsoleRenderer() {
    }

    void clearStatus() {
        if (this.statusLine) {
            System.out.print("\r                                                                              \r");
            this.statusLine = false;
        }
    }

    void updateStatus() {
        this.clearStatus();
        System.out.print((this.listening ? "SF enabled" : "SF disabled") + ", " + this.nclients + " " + (this.nclients == 1 ? "client" : "clients") + ", " + this.nread + " " + (this.nread == 1 ? "packet" : "packets") + " read, " + this.nwritten + " " + (this.nwritten == 1 ? "packet" : "packets") + " written" + " ");
        this.statusLine = true;
    }

    public void message(String string) {
        this.clearStatus();
        System.out.println(string);
        this.updateStatus();
    }

    public void updatePacketsRead(int n) {
        this.nread = n;
        this.updateStatus();
    }

    public void updatePacketsWritten(int n) {
        this.nwritten = n;
        this.updateStatus();
    }

    public void updateNumClients(int n) {
        this.nclients = n;
        this.updateStatus();
    }

    public void updateListenServerStatus(boolean bl) {
        this.listening = bl;
        this.updateStatus();
    }
}

