/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PLayer;
import org.piccolo2d.PRoot;
import org.piccolo2d.extras.swing.PScrollDirector;
import org.piccolo2d.extras.swing.PScrollPane;
import org.piccolo2d.extras.swing.PViewport;
import org.piccolo2d.util.PAffineTransform;
import org.piccolo2d.util.PBounds;

public class PDefaultScrollDirector
implements PScrollDirector,
PropertyChangeListener {
    protected PViewport viewPort;
    protected PScrollPane scrollPane;
    protected PCanvas view;
    protected PCamera camera;
    protected PRoot root;
    protected boolean scrollInProgress = false;

    public void install(PViewport targetViewPort, PCanvas targetView) {
        this.scrollPane = (PScrollPane)targetViewPort.getParent();
        this.viewPort = targetViewPort;
        this.view = targetView;
        if (targetView != null) {
            this.camera = targetView.getCamera();
            this.root = targetView.getRoot();
        }
        if (this.camera != null) {
            this.camera.addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.root != null) {
            this.root.addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void unInstall() {
        this.viewPort = null;
        this.view = null;
        if (this.camera != null) {
            this.camera.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.root != null) {
            this.root.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.camera = null;
        this.root = null;
    }

    public Point getViewPosition(Rectangle2D viewBounds) {
        Point pos = new Point();
        if (this.camera != null) {
            PBounds layerBounds = new PBounds();
            List layers = this.camera.getLayersReference();
            for (PLayer layer : layers) {
                layerBounds.add(layer.getFullBoundsReference());
            }
            this.camera.viewToLocal((Rectangle2D)layerBounds);
            layerBounds.add(viewBounds);
            pos.setLocation((int)(viewBounds.getX() - layerBounds.getX() + 0.5), (int)(viewBounds.getY() - layerBounds.getY() + 0.5));
        }
        return pos;
    }

    public Dimension getViewSize(Rectangle2D viewBounds) {
        Dimension size = new Dimension();
        if (this.camera != null) {
            PBounds bounds = new PBounds();
            List layers = this.camera.getLayersReference();
            for (PLayer layer : layers) {
                bounds.add(layer.getFullBoundsReference());
            }
            if (!bounds.isEmpty()) {
                this.camera.viewToLocal((Rectangle2D)bounds);
            }
            bounds.add(viewBounds);
            size.setSize((int)(bounds.getWidth() + 0.5), (int)(bounds.getHeight() + 0.5));
        }
        return size;
    }

    public void setViewPosition(double x, double y) {
        if (this.camera == null || this.scrollInProgress) {
            return;
        }
        this.scrollInProgress = true;
        PBounds layerBounds = new PBounds();
        List layers = this.camera.getLayersReference();
        for (PLayer layer : layers) {
            layerBounds.add(layer.getFullBoundsReference());
        }
        PAffineTransform at = this.camera.getViewTransform();
        at.transform((Rectangle2D)layerBounds, (Rectangle2D)layerBounds);
        PBounds viewBounds = this.camera.getBoundsReference();
        layerBounds.add(viewBounds);
        Point2D.Double newPoint = new Point2D.Double(layerBounds.getX() + x, layerBounds.getY() + y);
        this.camera.localToView((Point2D)newPoint);
        double newX = -(at.getScaleX() * ((Point2D)newPoint).getX() + at.getShearX() * ((Point2D)newPoint).getY());
        double newY = -(at.getShearY() * ((Point2D)newPoint).getX() + at.getScaleY() * ((Point2D)newPoint).getY());
        at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), newX, newY);
        this.camera.setViewTransform((AffineTransform)at);
        this.scrollInProgress = false;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        boolean isRelevantBoundsEvent;
        boolean isRelevantViewEvent = "viewTransform".equals(pce.getPropertyName());
        boolean bl = isRelevantBoundsEvent = this.isBoundsChangedEvent(pce) && (pce.getSource() == this.camera || pce.getSource() == this.view.getRoot());
        if (isRelevantViewEvent || isRelevantBoundsEvent) {
            if (this.shouldRevalidateScrollPane()) {
                this.scrollPane.revalidate();
            } else {
                this.viewPort.fireStateChanged();
            }
        }
    }

    private boolean isBoundsChangedEvent(PropertyChangeEvent pce) {
        return "bounds".equals(pce.getPropertyName()) || "fullBounds".equals(pce.getPropertyName());
    }

    public boolean shouldRevalidateScrollPane() {
        if (this.camera != null) {
            if (this.scrollPane.getHorizontalScrollBarPolicy() != 30 && this.scrollPane.getVerticalScrollBarPolicy() != 20) {
                return false;
            }
            PBounds layerBounds = new PBounds();
            List layers = this.camera.getLayersReference();
            for (PLayer layer : layers) {
                layerBounds.add(layer.getFullBoundsReference());
            }
            this.camera.viewToLocal((Rectangle2D)layerBounds);
            PBounds cameraBounds = this.camera.getBoundsReference();
            layerBounds.add(cameraBounds);
            int layerWidth = (int)(layerBounds.getWidth() + 0.5);
            int layerHeight = (int)(layerBounds.getHeight() + 0.5);
            int cameraWidth = (int)(cameraBounds.getWidth() + 0.5);
            int cameraHeight = (int)(cameraBounds.getHeight() + 0.5);
            if (this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth <= cameraWidth || !this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth > cameraWidth || this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight <= cameraHeight || !this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight > cameraHeight) {
                return true;
            }
        }
        return false;
    }
}

