[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil::magic::filetype n 1.0.2]
[see_also file(1)]
[see_also fileutil]
[see_also magic(5)]
[keywords {file recognition}]
[keywords {file type}]
[keywords {file utilities}]
[keywords type]
[moddesc   {file utilities}]
[titledesc {Procedures implementing file-type recognition}]
[category  {Programming tools}]
[require Tcl 8.4]
[require fileutil::magic::filetype [opt 1.0.2]]
[description]
[para]

This package provides a command for the recognition of file types in
pure Tcl.

[para]

The core part of the recognizer was generated from a "magic(5)" file
containing the checks to perform to recognize files, and associated
file-types.

[para]

[emph Beware!] This recognizer is large, about 276 Kilobyte of
generated Tcl code.

[list_begin definitions]

[call [cmd ::fileutil::magic::filetype] [arg filename]]

This command is similar to the command [cmd fileutil::fileType].

[para]

The output of the command for the specified file is a string
describing the type of the file.

[para]

This list will be empty if the type of the file is not recognized.

[list_end]

[section REFERENCES]

[list_begin enumerated]
[enum]
[uri ftp://ftp.astron.com/pub/file/ {File(1) sources}]

This site contains the current sources for the file command, including
the magic definitions used by it. The latter were used by us to
generate this recognizer.

[list_end]

[vset CATEGORY {fileutil :: magic}]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
