# -*- coding: utf-8 -*-
#
# Copyright © 2012-2015, Tails developers <tails@boum.org>

"""
A unified launcher for the most common Tails Installer usecases
"""

import os

from gi.repository import Gtk

from tails_installer import _
from tails_installer.utils import _get_datadir, is_running_from_tails

class TailsInstallerLauncherWindow(Gtk.ApplicationWindow):
    """ Our main dialog class """

    def __init__(self, args):
        Gtk.ApplicationWindow.__init__(self)

        self.args = args
        if os.getenv('DEBUG', 0):
            self.args = self.args + ['--verbose']

        self.connect('delete-event', Gtk.main_quit)
        builder = Gtk.Builder.new_from_file(
                os.path.join(_get_datadir(), 'tails-installer-launcher.ui'))
        builder.connect_signals(self)
        self.add(builder.get_object('box_launcher'))
        self.set_title(_("Tails Installer"))

        if not is_running_from_tails():
            builder.get_object('box_tails').set_visible(False)
            builder.get_object('box_standalone').set_visible(True)

        self.show()

    def run_tails_installer(self, args):
        args = ['tails-installer'] + args + self.args
        os.execvp('tails-installer', args)

    def on_clone_install(self, widget, data=None):
        self.run_tails_installer([ '-u', '-n', '--clone', '-P', '-m', '-x' ])

    def on_clone_upgrade(self, widget, data=None):
        self.run_tails_installer([ '-u', '-n', '-x', '--clone' ])

    def on_upgrade_iso(self, widget, data=None):
        self.run_tails_installer([ '-u', '-n', '-x' ])

    def on_install_iso(self, widget, data=None):
        self.run_tails_installer([ '-u', '-n', '-P', '-m', '-x' ])
