# -*- RPM-SPEC -*-
Summary: system-config-cluster is a utility which allows you to manage cluster configuration in a graphical setting.
Name: system-config-cluster
Version: 1.0.57
Release: 16
URL: http://www.redhat.com/ 
Source0: %{name}-%{version}.tar.gz

Patch0: bz352631.diff
Patch1: bz436939.diff
#Patch2: bz474155.diff
#Patch3: bz476260.diff
#Patch4: bz488957.diff
Patch5: bz491798.diff
Patch7: bz515443.diff
Patch8: bz517140a.diff
#Patch9: bz517140b.diff
Patch10: bz520866.diff
#Patch11: bz530171.diff
Patch12: bz546747.diff
Patch13: bz632599.diff
Patch14: bz642521.patch
Patch15: schema-docs.diff
Patch16: bz719658.patch
Patch17: bz532761.patch
Patch18: bz532761-2.patch
Patch19: bz808498.patch
Patch20: bz741292.patch
Patch21: bz824451.patch
Patch22: bz837045.patch

License: GPL
Group: Applications/System
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: /sbin/chkconfig
Requires: gnome-python2, pygtk2, pygtk2-libglade, gnome-python2-canvas 
Requires: rhpl >= 0.148.2
Requires: python >= 2.3
BuildRequires: perl(XML::Parser) gettext intltool

%description
system-config-cluster is a utility which allows you to manage cluster configuuration in a graphical setting.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
#%patch2 -p1 # Obsoleted by updated patch for #520886
#%patch3 -p1 # Obsoleted by updated patch for #520886
#%patch4 -p1 # Obsoleted by updated patch for #520886
%patch5 -p1
%patch7 -p1
%patch8 -p1
#%patch9 -p1 # Obsoleted by updated patch for #520886
%patch10 -p1
#%patch11 -p1 # Obsoleted by updated patch for #520886
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1

%build
%configure
make

%install
rm -rf %{buildroot}
%makeinstall

#Uncomment this when translations are done
#%find_lang %name

%clean
rm -rf %{buildroot}

#Replace the files line with the one commented out when translations are done
#%files -f %{name}.lang
%files

%defattr(-,root,root)
%doc COPYING
#%doc docs/ReleaseNotes
#%doc docs/html/*
%doc cluster_conf.html
%{_sbindir}/*
%{_bindir}/*
%{_datadir}/applications/system-config-cluster.desktop
%{_datadir}/system-config-cluster
%config %{_sysconfdir}/pam.d/system-config-cluster
%config %{_sysconfdir}/security/console.apps/system-config-cluster

%changelog
* Thu Jul 19 2012 Ryan McCabe <rmccabe@redhat.com> 1.0.57-16
  - Fix bz837045 (s-c-cluster tracebacks with unsupported fencing device)

* Wed Jun 13 2012 Ryan McCabe <rmccabe@redhat.com> 1.0.57-15
  - Fix bz824451 (Update the cluster schema for missing fence_ipmilan attributes)

* Wed May 23 2012 Ryan McCabe <rmccabe@redhat.com> 1.0.57-14
  - Fix bz741292 (system-config-cluster removes __independent_subtree from services)

* Wed May 23 2012 Ryan McCabe <rmccabe@redhat.com> 1.0.57-13
  - Fix bz808498 (Cisco UCS Fence Agent Fails Validatation)

* Thu Jan 05 2012 Ryan McCabe <rmccabe@redhat.com> 1.0.57-12
  - Additional fix for bz532761 (system-config-cluster lacks ability to create oracle resources)

* Fri Oct 28 2011 Ryan McCabe <rmccabe@redhat.com> 1.0.57-11
  - Fix bz532761 (system-config-cluster lacks ability to create oracle resources)

* Thu Oct 13 2011 Ryan McCabe <rmccabe@redhat.com> 1.0.57-10
  - Fix bz719658 (system-config-cluster writes and validates incorrect attribute for mysql resource)

* Thu Apr 07 2011 Lon Hohberger <lhh@redhat.com> 1.0.57-9
  - Add auto-generated schema documentation.
    (schema-docs.diff)
    Resolves: rhbz#645816

* Wed Feb 09 2011 Lon Hohberger <lhh@redhat.com> 1.0.57-8
  - Fix fence_brocade group
    (bz642521.patch)
    Resolves: rhbz#642521

* Mon Sep 27 2010 Lon Hohberger <lhh@redhat.com> 1.0.57-7
  - Add support for __max_restarts, __restart_expire_time,
    orainstance and oradatabase resources, Cisco MDS, Cisco
    UCS, and RHEV fencing agents.
  - Fix previous changelog entry
  - Resolves: rhbz#520866

* Mon Sep 27 2010 Ryan McCabe <rmccabe@redhat.com> 1.0.57-6
  - Fix bz632599 (Add support for xfs as a filesystem option in system-config-cluster)

* Tue Aug 31 2010 Lon Hohberger <lhh@redhat.com> 1.0.57-5
  - Fix failure to parse logging tags / out of date cluster.ng
  - Obsoletes previous patches for 474177, 476260, 4889057, 517140,
    and 53017
  - Resolves: rhbz520866
* Fri Aug 06 2010 Ryan McCabe <rmccabe@redhat.com> 1.0.57-4
  - Fix bz546747 (system-config-cluster does not populate ip correctly when you edit the ip resource with no subnet mask)
* Mon Dec 21 2009 Ryan McCabe <rmccabe@redhat.com> 1.0.57-3
  - Fix Red Hat bugzilla tickets: 352631 436939 474155 476260 488957 491798 515443 517140 520866 530171
* Thu Aug 6 2009 Ryan McCabe <rmccabe@redhat.com> 1.0.57-1.7
  - Provide actual fix for bz493996
* Tue Aug 4 2009 Ryan McCabe <rmccabe@redhat.com> 1.0.57-1.5
  - Fix missing %patch in spec file.
* Tue Aug 4 2009 Ryan McCabe <rmccabe@redhat.com> 1.0.57-1.4
  - Provide actual fix for bz491798
* Wed Jul 1 2009 Jim Parsons <jparsons@redhat.com> 1.0.57-1.3
  - Fixes for 475828, 493996
* Thu May 21 2009 Jim Parsons <jparsons@redhat.com> 1.0.57-1.0
  - Fixes for 456359, 465827, 488336, 491798, 474851
* Fri Sep 19 2008 Jim Parsons <jparsons@redhat.com> 1.0.55-1.0
  - Fixes for 239597, 456359, 462097 
* Tue Apr 8 2008 Jim Parsons <jparsons@redhat.com> 1.0.53-1.0
  - Fix for fedora 212477, finally
  - Fedora build 
* Tue Mar 28 2008 Jim Parsons <jparsons@redhat.com> 1.0.52-1.1
  - Schema support for 435950 
* Tue Mar 25 2008 Jim Parsons <jparsons@redhat.com> 1.0.52-1
  - Fix for 435950 
* Fri Aug 10 2007 Jim Parsons <jparsons@redhat.com> 1.0.50-1.3
  - Fix for 249705 
* Thu Jul 19 2007 Jim Parsons <jparsons@redhat.com> 1.0.50-1.2
  - Fix for 247731 
* Wed Jun 27 2007 Jim Parsons <jparsons@redhat.com> 1.0.50-1.1
  - bumping minor for missing files 
* Tue Jun 26 2007 Jim Parsons <jparsons@redhat.com> 1.0.50-1
  - SAP support and new resource agents as well as bz225441 and bz239594 
* Tue Apr 24 2007 Jim Parsons <jparsons@redhat.com> 1.0.47-1
  -  Version bump for zstream build
* Fri Apr 20 2007 Jim Parsons <jparsons@redhat.com> 1.0.46-1
  -  Fixes for 236057 and 236058
* Fri Jan 12 2007 Jim Parsons <jparsons@redhat.com> 1.0.39-1
  -  comment without a hash sign - sheesh
* Wed Jan 10 2007 Jim Parsons <jparsons@redhat.com> 1.0.38-1
  -  Bump for brew issue -- one more try
* Wed Jan 10 2007 Jim Parsons <jparsons@redhat.com> 1.0.37-1
  -  Bump for brew issue
* Wed Jan 10 2007 Jim Parsons <jparsons@redhat.com> 1.0.36-1
  -  Fix for bz 207482, many schema validation fixes
* Wed Oct 25 2006 Jim Parsons <jparsons@redhat.com> 1.0.35-1
  -  Fix for bz 211944, no more Xenvm
* Mon Oct 23 2006 Jim Parsons <jparsons@redhat.com> 1.0.34-1
  -  Fix for bz 211641
* Mon Oct 16 2006 Jim Parsons <jparsons@redhat.com> 1.0.33-1
  -  version bump
* Mon Oct 16 2006 Jim Parsons <jparsons@redhat.com> 1.0.32-1
  -  Fix oversight in Makefile
* Mon Oct 16 2006 Jim Parsons <jparsons@redhat.com> 1.0.31-1
  -  Beta 2 build. Fixes for bz210733, bz204497, bz202739
* Wed Sep 26 2006 Jim Parsons <jparsons@redhat.com> 1.0.30-1
  -  Fixed RSA II fence form, bz207671 and cluster name bz205662
* Wed Jun 14 2006 Jim Parsons <jparsons@redhat.com> 1.0.29-1
  -  spec file fix, version bump 
* Wed Jun 14 2006 Jim Parsons <jparsons@redhat.com> 1.0.28-1
  -  Version bump for fedora 
* Mon Jun 05 2006 Jim Parsons <jparsons@redhat.com> 1.0.27-1
  - Fix for bz192134  
* Tue May 16 2006 Jim Parsons <jparsons@redhat.com> 1.0.26-1
  - Fixes for bz179559,180507,181725,182516,183217,185686,190361  
* Wed Feb 08 2006 Jim Parsons <jparsons@redhat.com> 1.0.25-1
  -  Added rsa and drac/mc support. Also auth type field for ipmi. 
* Mon Jan 09 2006 Jim Parsons <jparsons@redhat.com> 1.0.24-1
  -  Build for fedora 
* Tue Dec 20 2005 Jim Parsons <jparsons@redhat.com> 1.0.23-1
  -  Removed unnecessary fence device field 
* Tue Dec 20 2005 Jim Parsons <jparsons@redhat.com> 1.0.22-1
  -  Version bump 
* Fri Dec 9 2005 Jim Parsons <jparsons@redhat.com> 1.0.21-1
  -  Some gui fixups, support for file system IDs, and some exposure of a few additional rgmanager params 
* Mon Dec 1 2005 Jim Parsons <jparsons@redhat.com> 1.0.20-1
  -  minor cleanup and version bump 
* Mon Dec 1 2005 Jim Parsons <jparsons@redhat.com> 1.0.19-1
  -  Version Bump
* Mon Dec 1 2005 Jim Parsons <jparsons@redhat.com> 1.0.18-1
  -  Fix for Fix for bz159965 and added samba support for bz173527
* Mon Nov 14 2005 Jim Parsons <jparsons@redhat.com> 1.0.17-1
  -  Fix for bz169139, and Version Bump - Build for Fedora.
* Mon Sep 12 2005 Jim Parsons <jparsons@redhat.com> 1.0.16-1
  -  Fix for bz167476.
* Wed Sep 12 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.16-1
  -  Fix for bz159965, 167742, 161784, 167739, 159781.
* Wed Sep 02 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.15-1
  -  Fix for bz167429.
* Wed Aug 31 2005 Jim Parsons <jparsons@redhat.com> 1.0.14-1
  -  Version Bump.
* Wed Aug 17 2005 Stanko Kupcevic <kupcevic@redhat.com> 1.0.13-1
  -  Fixes for bz161344, 160264, 160127, 163673, 163237, 160240, 164407, 159965, 165130, 165140, 161974, 165169, 164936, 165184, 164857, 166663, 166140, and validation of IP addresses.
* Tue Jun 07 2005 Jim Parsons <jparsons@redhat.com> 1.0.12-1
  -  Fix for bz159681.
* Mon Jun 06 2005 Jim Parsons <jparsons@redhat.com> 0.9.70-1
  -  Fixes for bz158909 and 156865, also desktop icon now works.
* Fri May 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.69-1
  -  version bump
* Fri May 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.67-1
  -  Fix spec file datadir issue
* Fri May 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.66-1
  -  Fixes for bz158918, 158418
* Wed May 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.65-1
  -  Version Bump
* Wed May 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.64-1
  -  Fixes for bz156865 and 158788
* Wed May 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.63-1
  -  Version Bump for Fedora
* Wed May 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.62-1
  - Fixes for bz158765 and 157077 
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.61-1
  - Version Bump 
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.60-1
  - Fix for 156865 
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.59-1
  - Version Bump
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.58-1
  - Fix for bz158341 and 156302
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.57-1
  - Fix for bz157077,158419,158415
* Tue May 24 2005 Jim Parsons <jparsons@redhat.com> 0.9.56-1
  - Fix for bz158610
* Mon May 23 2005 Jim Parsons <jparsons@redhat.com> 0.9.55-1
  - Fixes for bz158357, 155052, 158416, 154938
* Tue May 20 2005 Jim Parsons <jparsons@redhat.com> 0.9.54-1
  - Fixes for bz156149,158230,157094,158118
* Tue May 17 2005 Jim Parsons <jparsons@redhat.com> 0.9.53-1
  - Fixes for bz156975,156976,157011,156866,157388
* Thu May 12 2005 Jim Parsons <jparsons@redhat.com> 0.9.52-1
  - Added support for IPMilan and Bullpap fence agents.
* Mon May 09 2005 Jim Parsons <jparsons@redhat.com> 0.9.51-1
  - Fixes for bz157102,157094,157077,156149,157097,157105,156933,156381.
* Mon May 09 2005 Jim Parsons <jparsons@redhat.com> 0.9.50-1
  - Fixes for bz149124.
* Mon May 09 2005 Jim Parsons <jparsons@redhat.com> 0.9.49-1
  - Fixes for bz157080,157210, exclusive checkbox for services.
* Tue May 03 2005 Jim Parsons <jparsons@redhat.com> 0.9.48-1
  - Fixed bz156717,156329,156718,156149.
* Tue May 03 2005 Jim Parsons <jparsons@redhat.com> 0.9.47-1
  - Version Bump.
* Tue May 03 2005 Jim Parsons <jparsons@redhat.com> 0.9.46-1
  - Version Bump.
* Mon May 02 2005 Stanko Kupcevic <kupcevic@redhat.com> 0.9.45-1
  - Added two node special case
* Fri Apr 29 2005 Jim Parsons <jparsons@redhat.com> 0.9.44-1
  - Fixed bz149705,156302,155039,156028,149707
* Thu Apr 28 2005 Jim Parsons <jparsons@redhat.com> 0.9.43-1
  - Fixed bz156263,149705,149128,154891,156143,156302,149128,156282,149124
* Thu Apr 28 2005 Jim Parsons <jparsons@redhat.com> 0.9.42-1
  - Fixed bz149508,149662,154839,156002,149124
* Wed Apr 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.41-1
  - another Schema checking fix
* Wed Apr 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.40-1
  - Schema checking fix
* Wed Apr 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.39-1
  - Fix for bz155033, and some other minor stuff
* Wed Apr 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.38-1
  - minor amendment to ng file
* Wed Apr 27 2005 Jim Parsons <jparsons@redhat.com> 0.9.37-1
  - DnD support for service enabling, fixed various nits
* Tue Apr 26 2005 Jim Parsons <jparsons@redhat.com> 0.9.36-1
  - Fixed bz155064,155023,155035,149897,154530,154860,154938,155049,154866,155042
* Mon Apr 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.35-1
  - Removed Debug Statements
* Mon Apr 25 2005 Jim Parsons <jparsons@redhat.com> 0.9.34-1
  - Fixed bz155024,155028,155052,155046,155269,154845,154888,154546
* Fri Apr 15 2005 Jim Parsons <jparsons@redhat.com> 0.9.33-1
  - Fixed getServicesInfo bug
* Fri Apr 15 2005 Jim Parsons <jparsons@redhat.com> 0.9.32-1
  - Fixed prop rendering for tree components
* Thu Apr 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.31-1
  - Fixes for bz154835, 154831,154843,150899,154830,154847,
    154860,151068 
* Thu Apr 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.30-1
  - Multicast config and a new tool for switching lock managers. 
* Thu Apr 07 2005 Jim Parsons <jparsons@redhat.com> 0.9.29-1
  - Fence Daemon config support plus final cluster.ng. 
* Thu Mar 31 2005 Jim Parsons <jparsons@redhat.com> 0.9.28-1
  - Fixed nits. 
* Thu Mar 31 2005 Jim Parsons <jparsons@redhat.com> 0.9.27-1
  - Fixed nits. 
* Wed Mar 30 2005 Jim Parsons <jparsons@redhat.com> 0.9.26-1
  - Fixed colored text issue. Finally. Also fixes for nits. 
* Wed Mar 30 2005 Jim Parsons <jparsons@redhat.com> 0.9.25-1
  - Version bump. 
* Tue Mar 29 2005 Jim Parsons <jparsons@redhat.com> 0.9.24-1
  - Added support for Netfs and Clusterfs. Removed regression code. 
* Tue Mar 29 2005 Jim Parsons <jparsons@redhat.com> 0.9.23-1
  - Fixes in services interface. 
* Tue Mar 29 2005 Jim Parsons <jparsons@redhat.com> 0.9.22-1
  - Added new class file 
* Tue Mar 29 2005 Jim Parsons <jparsons@redhat.com> 0.9.21-1
  - Fix for bz149272 and services tree view complete 
* Mon Mar 28 2005 Jim Parsons <jparsons@redhat.com> 0.9.19-1
  - Fix for bz149672 and propagate error
* Mon Mar 28 2005 Jim Parsons <jparsons@redhat.com> 0.9.18-1
  - Added Exception Handler for getNodesInfo and reworded 'save changes?'
* Mon Mar 28 2005 Jim Parsons <jparsons@redhat.com> 0.9.17-1
  - Fixes for bz149123, 149885, 149660, 149508, 149488, 149897,
    150895, 150813, 149124, 149662, 149128, 149508, 149545, 149707
* Tue Mar 22 2005 Jim Parsons <jparsons@redhat.com> 0.9.16-1
  - Discovered nits post install fixed
* Mon Mar 21 2005 Jim Parsons <jparsons@redhat.com> 0.9.15-1
  - Completion of service cfg ui - mgmt tab nodes
* Tue Mar 15 2005 Jim Parsons <jparsons@redhat.com> 0.9.14-1
  - Fixes for bz150894 and 149275
* Mon Mar 14 2005 Jim Parsons <jparsons@redhat.com> 0.9.12-1
  - Fixes for bz149897, 149123, 149124, 149674, 149676, 149761, 149269, 149670.
    Also added in Service Creation dialog panel.
* Thu Mar 10 2005 Jim Parsons <jparsons@redhat.com> 0.9.11-1
  - Added IPAddrEntry to dist. Changed name of ResourceGroup to Service
* Thu Mar 10 2005 Jim Parsons <jparsons@redhat.com> 0.9.10-1
  - Added Command Handler code
* Wed Mar 02 2005 Jim Parsons <jparsons@redhat.com> 0.9.9-1
  - Fixed bz149264 and 149287
* Wed Mar 02 2005 Jim Parsons <jparsons@redhat.com> 0.9.7-1
  - Aded selection method for choosing gulm lockservers
* Fri Feb 18 2005 Jim Parsons <jparsons@redhat.com> 0.9.6-1
  - Added dialog choice for locking type
* Tue Feb 01 2005 Jim Parsons <jparsons@redhat.com> 0.9.5-1
  - Many fixes and completions. Added check boxes for restricted
    and ordered failover domains. Added properties for fences.
    Fixed bug in fence devices section. Added support for GULM
    in UI.
* Tue Jan 11 2005 Jim Parsons <jparsons@redhat.com> 0.9.4-1
  - Added delete fence device functionality.
* Mon Jan 10 2005 Jim Parsons <jparsons@redhat.com> 0.9.3-1
  - Improvements to Props renderer.
* Tue Jan 04 2005 Jim Parsons <jparsons@redhat.com> 0.9.1-1
  - Initial copy
