/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _UTF_TEST_H
#define _UTF_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>
 
// util
#include "util/apr.h"



class UtfTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( UtfTest );
  CPPUNIT_TEST( testUtf8 );
  CPPUNIT_TEST( testUtf32be );
  CPPUNIT_TEST( testUtf32le );
  CPPUNIT_TEST( testUtf16be );
  CPPUNIT_TEST( testUtf16le );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testUtf8();
  void testUtf32be();
  void testUtf32le();
  void testUtf16be();
  void testUtf16le();

private:
  apr::Pool _pool;
};

#endif // _UTF_TEST_H
