/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SINGLEPROJECTREADER_H
#define _SINGLEPROJECTREADER_H

// sc
#include "../Project.h"
#include "sublib/config/ConfigValue.h"

// qt
class QString;


class SingleProjectReader
{
public:
  SingleProjectReader( long prjIdx, const ConfigValues& values );
  virtual ~SingleProjectReader();

  void read();
  Project* getProject();

private:
  void readRoot();
  void readTrunkItem();
  void readBranchesItem();
  void readTagsItem();
  void readWorkingCopyItems();
  void readRepositoryItems();
  void readWorkingCopySubItems( const ConfigValues& values,
    Project::Item& item );

  void readRepositoryItem( const ConfigValues& values, Project::Item&
    item );
  void readWorkingCopyItem( const ConfigValues& values, Project::Item&
    item );
  void readWorkingCopySubItem( const ConfigValues& values,
    Project::SubItem& item );

  /** filter the values to pattern, this is not a regular expression. */
  void filterConfigValues( const sc::String& pattern, ConfigValues&
    out );
  void filterConfigValues( const sc::String& pattern, const
    ConfigValues& in, ConfigValues& out );

  // in
  ConfigValues _values;
  long         _prjIdx;

  // out
  Project*     _project;
};

#endif // _SINGLEPROJECTREADER_H
