/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "SortSafe.h"

// qt
#include <Qt3Support/Q3ListView>


SortSafe::SortSafe( Q3ListView* view )
: _view(view), _col(-1), _asc(true)
{
  _col = _view->sortColumn();
  _asc = _view->sortOrder() == Qt::Ascending ? true : false;

  view->setSorting( -1 );
}

SortSafe::~SortSafe()
{
  _view->setSorting( _col, _asc );
}
