/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.solr.client.solrj.impl;

import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.JavaBinCodec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

/**
 * @version $Id: BinaryResponseParser.java 745392 2009-02-18 06:27:20Z shalin $
 * @since solr 1.3
 */
public class BinaryResponseParser extends ResponseParser {
  public String getWriterType() {
    return "javabin";
  }

  public NamedList<Object> processResponse(InputStream body, String encoding) {
    try {
      return (NamedList<Object>) new JavaBinCodec().unmarshal(body);
    } catch (IOException e) {
      throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", e);

    }
  }


  public String getVersion() {
    return "1";
  }

  public NamedList<Object> processResponse(Reader reader) {
    throw new RuntimeException("Cannot handle character stream");
  }
}
