#include <bus.h>
#include <phy.h>

#define NS9750_ETH_BASE		(0xa0600000)
#define NS9750_ETH_MAPSIZE	(0x2000)

#define NS9750_ETH_EGCR1	(0xa0600000)
#define NS9750_ETH_EGCR2	(0xa0600004)
#define NS9750_ETH_EGSR		(0xa0600008)
#define NS9750_ETH_ETSR		(0xa0600018)
#define NS9750_ETH_ERSR		(0xa060001c)
#define NS9750_ETH_MAC1		(0xa0600400)
#define NS9750_ETH_MAC2		(0xa0600404)
#define NS9750_ETH_IPGT		(0xa0600408)
#define NS9750_ETH_IPGR		(0xa060040c)
#define NS9750_ETH_CLRT		(0xa0600410)
#define NS9750_ETH_MAXF		(0xa0600414)
#define NS9750_ETH_SUPP		(0xa0600418)
#define NS9750_ETH_MCFG		(0xa0600420)
#define NS9750_ETH_MCMD		(0xa0600424)
#define NS9750_ETH_MADR		(0xa0600428)
#define NS9750_ETH_MWTD		(0xa060042c)
#define NS9750_ETH_MRDD		(0xa0600430)
#define NS9750_ETH_MIND		(0xa0600434)
#define NS9750_ETH_SA1		(0xa0600440)
#define NS9750_ETH_SA2		(0xa0600444)
#define NS9750_ETH_SA3		(0xa0600448)
#define NS9750_ETH_SAFR		(0xa0600500)
#define NS9750_ETH_HT1		(0xa0600504)
#define NS9750_ETH_HT2		(0xa0600508)

#define NS9750_ETH_TR64		(0xa0600680)
#define	NS9750_ETH_TR127	(0xa0600084)	
#define	NS9750_ETH_TR255	(0xa0600088)	
#define	NS9750_ETH_TR511	(0xa060008c)	
#define	NS9750_ETH_TR1K		(0xa0600090)	
#define	NS9750_ETH_TRMAX	(0xa0600094)	
#define	NS9750_ETH_TRMGV	(0xa0600098)
#define NS9750_ETH_RBYT		(0xa060069c)
#define NS9750_ETH_RPKT		(0xa06006a0)
#define NS9750_ETH_RFCS		(0xa06006a4)
#define NS9750_ETH_RMCA		(0xa06006a8)
#define NS9750_ETH_RBCA		(0xa06006ac)
#define NS9750_ETH_RXCF		(0xa06006b0)
#define NS9750_ETH_RXPF		(0xa06006b4)
#define NS9750_ETH_RXUO		(0xa06006b8)
#define NS9750_ETH_RALN		(0xa06006bc)
#define NS9750_ETH_RFLR		(0xa06006c0)
#define NS9750_ETH_RCDE		(0xa06006c4)
#define NS9750_ETH_RCSE		(0xa06006c8)
#define	NS9750_ETH_RUND		(0xa06006cc)
#define NS9750_ETH_ROVR		(0xa06006d0)
#define NS9750_ETH_RFRG		(0xa06006d4)
#define NS9750_ETH_RJBR		(0xa06006d8)
#define NS9750_ETH_TBYT		(0xa06006e0)
#define NS9750_ETH_TPKT		(0xa06006e4)
#define NS9750_ETH_TMCA		(0xa06006e8)
#define NS9750_ETH_TBCA		(0xa06006ec)
#define NS9750_ETH_TDFR		(0xa06006f4)
#define NS9750_ETH_TEDF		(0xa06006f8)
#define NS9750_ETH_TSCL		(0xa06006fc)
#define NS9750_ETH_TMCL		(0xa0600700)
#define NS9750_ETH_TLCL		(0xa0600704)
#define NS9750_ETH_TXCL		(0xa0600708)
#define NS9750_ETH_TNCL		(0xa060070c)
#define NS9750_ETH_TJBR		(0xa0600718)
#define NS9750_ETH_TFCS		(0xa060071c)
#define NS9750_ETH_TOVR		(0xa0600724)
#define NS9750_ETH_TUND		(0xa0600728)
#define NS9750_ETH_TFRG		(0xa060072c)
#define NS9750_ETH_CAR1		(0xa0600730)
#define		ETH_C164	(1<<31)
#define		ETH_C1127	(1<<30)
#define		ETH_C1255	(1<<29)
#define		ETH_C1511	(1<<28)
#define		ETH_C11K	(1<<27)
#define		ETH_C1MAX	(1<<26)
#define		ETH_C1MGV	(1<<25)
#define		ETH_C1RBY	(1<<16)
#define		ETH_C1RPK	(1<<15)
#define		ETH_C1RFC	(1<<14)
#define		ETH_C1RMC	(1<<13)
#define		ETH_C1RBC	(1<<12)
#define		ETH_C1RXC	(1<<11)
#define		ETH_C1RXP	(1<<10)
#define		ETH_C1RXU	(1<<9)
#define		ETH_C1RAL	(1<<8)
#define		ETH_C1RFL	(1<<7)
#define		ETH_C1RCD	(1<<6)
#define 	ETH_C1RCS	(1<<5)
#define		ETH_C1RUN	(1<<4)
#define		ETH_C1ROV	(1<<3)
#define 	ETH_C1RFR	(1<<2)
#define	 	ETH_C1RJB	(1<<1)

#define NS9750_ETH_CAR2		(0xa0600734)
#define		ETH_C2TJB	(1<<19)
#define		ETH_C2TFC	(1<<18)
#define		ETH_C2TOV	(1<<16)
#define		ETH_C2TUN	(1<<15)
#define		ETH_C2TFG	(1<<14)
#define		ETH_C2TBY	(1<<13)
#define		ETH_C2TPK	(1<<12)
#define		ETH_C2TMC	(1<<11)
#define		ETH_C2TBC	(1<<10)
#define		ETH_C2TDF	(1<<8)
#define		ETH_C2TED	(1<<7)
#define		ETH_C2TSC	(1<<6)
#define		ETH_C2TMA	(1<<5)
#define		ETH_C2TLC	(1<<4)
#define		ETH_C2TXC	(1<<3)
#define	 	ETH_C2TNC	(1<<2)
#define NS9750_ETH_CAM1		(0xa0600738)
#define		ETH_M164	(1<<31)
#define		ETH_M1127	(1<<30)
#define		ETH_M1255	(1<<29)
#define		ETH_M1511	(1<<28)
#define		ETH_M111K	(1<<27)
#define		ETH_M1MAX	(1<<26)
#define		ETH_M1MGV	(1<<25)
#define		ETH_M1RBY	(1<<16)
#define		ETH_M1RPK	(1<<15)
#define		ETH_M1RFC	(1<<14)
#define		ETH_M1RMC	(1<<13)
#define		ETH_M1RBC	(1<<12)
#define		ETH_M1RXC	(1<<11)
#define		ETH_M1RXP	(1<<10)
#define		ETH_M1RXU	(1<<9)
#define		ETH_M1RAL	(1<<8)
#define		ETH_M1RFL	(1<<7)
#define		ETH_M1RCD	(1<<6)
#define 	ETH_M1RCS	(1<<5)
#define		ETH_M1RUN	(1<<4)
#define		ETH_M1ROV	(1<<3)
#define 	ETH_M1RFR	(1<<2)
#define	 	ETH_M1RJB	(1<<1)
#define NS9750_ETH_CAM2		(0xa060073c)
#define		ETH_M2TJB	(1<<19)
#define		ETH_M2TFC	(1<<18)
#define		ETH_M2TOV	(1<<16)
#define		ETH_M2TUN	(1<<15)
#define		ETH_M2TFG	(1<<14)
#define		ETH_M2TBY	(1<<13)
#define		ETH_M2TPK	(1<<12)
#define		ETH_M2TMC	(1<<11)
#define		ETH_M2TBC	(1<<10)
#define		ETH_M2TDF	(1<<8)
#define		ETH_M2TED	(1<<7)
#define		ETH_M2TSC	(1<<6)
#define		ETH_M2TMA	(1<<5)
#define		ETH_M2TLC	(1<<4)
#define		ETH_M2TXC	(1<<3)
#define	 	ETH_M2TNC	(1<<2)

#define NS9750_ETH_RXAPTR	(0xa0600a00)
#define NS9750_ETH_RXBPTR	(0xa0600a04)
#define NS9750_ETH_RXCPTR	(0xa0600a08)
#define NS9750_ETH_RXDPTR	(0xa0600a0c)
#define NS9750_ETH_EINTR	(0xa0600a10)
#define NS9750_ETH_EINTREN	(0xa0600a14)
#define NS9750_ETH_TXPTR	(0xa0600a18)
#define NS9750_ETH_TXRPTR	(0xa0600a1c)
#define NS9750_ETH_TXERBD	(0xa0600a20)
#define	NS9750_ETH_TXSPTR	(0xa0600a24)
#define NS9750_ETH_RXAOFF	(0xa0600a28)
#define NS9750_ETH_RXBOFF	(0xa0600a2c)
#define NS9750_ETH_RXCOFF	(0xa0600a30)
#define NS9750_ETH_RXDOFF	(0xa0600a34)
#define NS9750_ETH_TXOFF	(0xa0600a38)
#define NS9750_ETH_RXFREE	(0xa0600a3c)
#define NS9750_ETH_TXBD		(0xa0601000)

/* System Controller Interrupt relative Interrupt numbers */
#define NS9750_IRQ_ETH_RECEIVE         4
#define NS9750_IRQ_ETH_TRANSMIT        5
#define NS9750_IRQ_ETH_PHY             6

BusDevice *NS9750_EthInit(const char *devname);
int NS9750_EthRegisterPhy(BusDevice *dev,PHY_Device *phy,unsigned int phy_addr);
