/*
 * ----------------------------------------------------
 *
 * Command interpreter for debugging language
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */

typedef struct DbgInterp  DbgInterp;
typedef struct DbgCmd DbgCmd; 

typedef int DbgCmdProc (void *clientData,DbgInterp *Interp,int argc,char *argv[]);
typedef void Dbg_CmdDeleteProc(void *clientData);

DbgInterp * DbgInterpr_New(); 
void DbgInterp_Del(DbgInterp *interp);
DbgCmd *DbgInterp_CreateCmd(DbgInterp *,char *cmdname,DbgCmdProc *,void *clientData,Dbg_CmdDeleteProc *);
int DbgInterp_Eval(DbgInterp *interp,char *script);



struct DbgCmd {
	char *name;
	void *clientData;
	DbgCmdProc *cmdProc;
	Dbg_CmdDeleteProc *delProc;
};
