/*
 * ALPS: look up the number of cores per compute-node
 *
 * On Cray CLE systems the number-of-cores per compute node is variable
 * (2..12) and needs to be determined from the system configuration
 * via look-up in the SDB database.
 */
#include "basil_mysql.h"

int main(int ac, char **av)
{
	MYSQL *handle = cray_connect_sdb();
	int num_cores;

	if (handle == NULL)
		errx(1, "can not connect to SDB database");

	num_cores = cray_num_compute_node_cores(handle);
	if (num_cores < 0)
		errx(1, "number-of-cores lookup failed");

	printf("Number of compute-node-cores: %i\n", num_cores);

	mysql_close(handle);
	return EXIT_SUCCESS;
}
