#include "glsl_shaders.h"

namespace GLSL_Shaders
{
   const std::string tvl1_flow_new_update_p = 
      "#version 330\n"
      "\n"
      "uniform sampler2D uv_src;\n"
      "uniform sampler2D p_uv_src;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;\n"
      "\n"
      "uniform float timestep;\n"
      "uniform float rcpLambda_p;\n"
      "\n"
      "const float eps_dual = 0.0f;\n"
      "\n"
      "vec2 tv(vec4 uv_grad)\n"
      "{\n"
      "   return vec2(length(uv_grad.xz), length(uv_grad.yw));\n"
      "}\n"
      "\n"
      "void main(void)\n"
      "{\n"
      "   vec2 st0 = gl_TexCoord[0].st;\n"
      "   vec4 stEW = gl_TexCoord[1];\n"
      "   vec4 stSN = gl_TexCoord[2];\n"
      "\n"
      "   vec2 uv = texture2D(uv_src, st0).xy;\n"
      "   vec4 uv_ES = vec4(0.0f);\n"
      "   uv_ES.xy = texture2D(uv_src, stEW.xy).xy;\n"
      "   uv_ES.zw = texture2D(uv_src, stSN.xy).xy;\n"
      "\n"
      "   vec4 p_uv = texture2D(p_uv_src, st0);\n"
      "\n"
      "   // The right clamping mode should handle the boundary conditions.\n"
      "   vec4 uv_grad = uv_ES - uv.xyxy;\n"
      "\n"
      "   p_uv -= timestep * (uv_grad + eps_dual * p_uv);\n"
      "\n"
      "#if 0\n"
      "   const float denom = max(1.0f, rcpLambda_p * length(p_uv));\n"
      "   p_uv /= denom;\n"
      "#else\n"
      "   vec2 denom = max(vec2(1.0f), rcpLambda_p * tv(p_uv));\n"
      "   p_uv /= denom.xyxy;\n"
      "#endif\n"
      "   my_FragColor = p_uv;\n"
      "}\n"
      "\n";

   const std::string flow_warp_image =
      "#version 330\n"
      "\n"
      "uniform sampler2D uv_src;\n"
      "uniform sampler2D I0_tex;\n"
      "uniform sampler2D I1_tex;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;\n"
      "\n"
      "float signum(float value)\n"
      "{\n"
      "   return (value < 0) ? -1 : 1;\n"
      "}\n"
      "\n"
      "void main()\n"
      "{\n"
      "   vec2 st0 = gl_TexCoord[0].st;\n"
      "   vec3 st3 = gl_TexCoord[3].stp;\n"
      "\n"
      "   const float eps = 0.001f;\n"
      "\n"
      "   vec2 uv = texture2D(uv_src, st0).xy;\n"
      "   vec3 I0 = texture2D(I0_tex, st0).xyz;\n"
      "   vec3 I1 = texture2D(I1_tex, st0 + st3.xy*uv).xyz;\n"
      "   I1.yz *= st3.z;\n"
      "\n"
      "   // Central differences and use gradients from both images\n"
      "   const vec2 ds0 = vec2(1, 0); // I0_tex has nearest texture filtering\n"
      "   const vec2 dt0 = vec2(0, 1);\n"
      "   const vec2 ds = vec2(0.5, 0);\n"
      "   const vec2 dt = vec2(0, 0.5);\n"
      "   vec2 I0grad;\n"
      "   vec2 I1grad;\n"
      "   I0grad.x = 0.5f * (texture2D(I0_tex, st0 + st3.xy*ds0).x - texture2D(I0_tex, st0 - st3.xy*ds0).x);\n"
      "   I0grad.y = 0.5f * (texture2D(I0_tex, st0 + st3.xy*dt0).x - texture2D(I0_tex, st0 - st3.xy*dt0).x);\n"
      "   I1grad.x = texture2D(I1_tex, st0 + st3.xy*(uv+ds)).x - texture2D(I1_tex, st0 + st3.xy*(uv-ds)).x;\n"
      "   I1grad.y = texture2D(I1_tex, st0 + st3.xy*(uv+dt)).x - texture2D(I1_tex, st0 + st3.xy*(uv-dt)).x;\n"
      "   I1.yz = 0.5f * (I0grad + I1grad);\n"
      "\n"
      "   // Avoid zero gradients\n"
      "   I1.y = (abs(I1.y) < eps) ? (signum(I1.y) * eps) : I1.y;\n"
      "   I1.z = (abs(I1.z) < eps) ? (signum(I1.z) * eps) : I1.z;\n"
      "\n"
      "   vec4 color_out;\n"
      "   color_out.x = I1.x - dot(I1.yz, uv) - I0.x;\n"
      "   color_out.yz = I1.yz;\n"
      "   color_out.w = abs(I1.x-I0.x);\n"
      "\n"
      "   my_FragColor = color_out;\n"
      "}\n";

   const std::string pyramid_with_derivative_pass1v =
      "#version 330\n"
      "\n"
      "uniform sampler2D src_tex;\n"
      "\n"
      "uniform int presmoothing;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;\n"
      "\n"
      "void main()\n"
      "{\n"
      "   vec4 st0 = gl_TexCoord[0];\n"
      "   vec4 st1 = gl_TexCoord[1];\n"
      "   vec4 st2 = gl_TexCoord[2];\n"
      "   vec4 st3 = gl_TexCoord[3];\n"
      "   if (presmoothing == 3) {\n"
      "      // This is the (odd) binomial kernel [0 1 6 15 20 15 6 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 6, 15) / 64.0f;\n"
      "      const vec4 f2 = vec4(20, 15, 6, 1) / 64.0f;\n"
      "\n"
      "      const vec4 df = vec4(1, 6, 14, 14) / 128.0f;\n"
      "\n"
      "      vec2 ds = st0.zw - st0.xy;\n"
      "\n"
      "      vec4 g1, g2;\n"
      "      float  g3;\n"
      "      g1.x = texture2D(src_tex, st0.xy - ds).x;\n"
      "      g1.y = texture2D(src_tex, st0.xy).x;\n"
      "      g1.z = texture2D(src_tex, st0.zw).x;\n"
      "      g1.w = texture2D(src_tex, st1.xy).x;\n"
      "      g2.x = texture2D(src_tex, st1.zw).x;\n"
      "      g2.y = texture2D(src_tex, st2.xy).x;\n"
      "      g2.z = texture2D(src_tex, st2.zw).x;\n"
      "      g2.w = texture2D(src_tex, st3.xy).x;\n"
      "      g3   = texture2D(src_tex, st3.zw).x;\n"
      "\n"
      "      g1 *= 255.0f;\n"
      "      g2 *= 255.0f;\n"
      "      g3 *= 255.0f;\n"
      "\n"
      "      float v = dot(f1, g1) + dot(f2, g2);\n"
      "      float dv = -dot(df, g1) + dot(df, vec4(g2.yzw, g3));\n"
      "      my_FragColor.x = v;\n"
      "      my_FragColor.y = dv;\n"
      "   } else if (presmoothing == 2) {\n"
      "      // This is the (odd) binomial kernel [0 1 4 6 4 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 4, 6) / 16.0f;\n"
      "      const vec3 f2 = vec3(4, 1, 0) / 16.0f;\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -4, -5, 0) / 32.0f;\n"
      "      const vec3 df2 = vec3(5, 4, 1) / 32.0f;\n"
      "\n"
      "      vec4 g1;\n"
      "      vec3 g2;\n"
      "\n"
      "      g1.x = texture2D(src_tex, st0.xy).x;\n"
      "      g1.y = texture2D(src_tex, st0.zw).x;\n"
      "      g1.z = texture2D(src_tex, st1.xy).x;\n"
      "      g1.w = texture2D(src_tex, st1.zw).x;\n"
      "      g2.x = texture2D(src_tex, st2.xy).x;\n"
      "      g2.y = texture2D(src_tex, st2.zw).x;\n"
      "      g2.z = texture2D(src_tex, st3.xy).x;\n"
      "\n"
      "      g1 *= 255.0f;\n"
      "      g2 *= 255.0f;\n"
      "\n"
      "      float v = dot(f1, g1) + dot(f2, g2);\n"
      "      float dv = dot(df1, g1) + dot(df2, g2);\n"
      "      my_FragColor.x = v;\n"
      "      my_FragColor.y = dv;\n"
      "   } else if (presmoothing == 1) {\n"
      "      // This is the (odd) binomial kernel [0 1 2 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 2, 1) / 4.0f;\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -2, 0, 2) / 8.0f;\n"
      "      const float df2 = 1.0 / 8.0f;\n"
      "\n"
      "      vec4 g1;\n"
      "      float  g2;\n"
      "\n"
      "      g1.x = texture2D(src_tex, st0.zw).x;\n"
      "      g1.y = texture2D(src_tex, st1.xy).x;\n"
      "      g1.z = texture2D(src_tex, st1.zw).x;\n"
      "      g1.w = texture2D(src_tex, st2.xy).x;\n"
      "      g2   = texture2D(src_tex, st2.zw).x;\n"
      "\n"
      "      g1 *= 255.0f;\n"
      "      g2 *= 255.0f;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv = dot(df1, g1) + df2*g2;\n"
      "      my_FragColor.x = v;\n"
      "      my_FragColor.y = dv;\n"
      "   } else if (presmoothing == 4) {\n"
      "      // This is the (odd) kernel [0 1 6 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 6, 1) / 8.0f;\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -6, 0, 6) / 16.0f;\n"
      "      const float df2 = 1.0 / 16.0f;\n"
      "\n"
      "      vec4 g1;\n"
      "      float  g2;\n"
      "\n"
      "      g1.x = texture2D(src_tex, st0.zw).x;\n"
      "      g1.y = texture2D(src_tex, st1.xy).x;\n"
      "      g1.z = texture2D(src_tex, st1.zw).x;\n"
      "      g1.w = texture2D(src_tex, st2.xy).x;\n"
      "      g2   = texture2D(src_tex, st2.zw).x;\n"
      "\n"
      "      g1 *= 255.0f;\n"
      "      g2 *= 255.0f;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv = dot(df1, g1) + df2*g2;\n"
      "      my_FragColor.x = v;\n"
      "      my_FragColor.y = dv;\n"
      "   } else {\n"
      "\n"
      "      const vec4 f1 = vec4(0, 0, 1, 0);\n"
      "\n"
      "      const vec4 df1 = vec4(0, -1, 0, 1) / 2.0f;\n"
      "\n"
      "      vec4 g1;\n"
      "\n"
      "      g1.x = 0;\n"
      "      g1.y = texture2D(src_tex, st1.xy).x;\n"
      "      g1.z = texture2D(src_tex, st1.zw).x;\n"
      "      g1.w = texture2D(src_tex, st2.xy).x;\n"
      "\n"
      "      g1 *= 255.0f;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv = dot(df1, g1);\n"
      "      my_FragColor.x = v;\n"
      "      my_FragColor.y = dv;\n"
      "   }\n"
      "}\n";
         
   const std::string pyramid_with_derivative_pass1h =
      "#version 330\n"
      "\n"
      "uniform sampler2D src_tex;\n"
      "\n"
      "uniform int presmoothing;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;\n"
      "\n"
      "void main()\n"
      "{\n"
      "   vec4 st0 = gl_TexCoord[0];\n"
      "   vec4 st1 = gl_TexCoord[1];\n"
      "   vec4 st2 = gl_TexCoord[2];\n"
      "   vec4 st3 = gl_TexCoord[3];\n"
      "\n"
      "   vec3 color;\n"
      "   if (presmoothing == 3) {\n"
      "      // This is the (odd) binomial kernel [0 1 6 15 20 15 6 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 6, 15) / 64.0f;\n"
      "      const vec4 f2 = vec4(20, 15, 6, 1) / 64.0f;\n"
      "\n"
      "      const vec4 df = vec4(1, 6, 14, 14) / 128.0f;\n"
      "\n"
      "      vec2 ds = st0.zw - st0.xy;\n"
      "\n"
      "      vec4 rawVal1, rawVal2, rawVal3, rawVal4, rawVal5, rawVal6, rawVal7, rawVal8, rawVal9;\n"
      "\n"
      "      rawVal1 = texture2D(src_tex, st0.xy - ds);\n"
      "      rawVal2 = texture2D(src_tex, st0.xy);\n"
      "      rawVal3 = texture2D(src_tex, st0.zw);\n"
      "      rawVal4 = texture2D(src_tex, st1.xy);\n"
      "      rawVal5 = texture2D(src_tex, st1.zw);\n"
      "      rawVal6 = texture2D(src_tex, st2.xy);\n"
      "      rawVal7 = texture2D(src_tex, st2.zw);\n"
      "      rawVal8 = texture2D(src_tex, st3.xy);\n"
      "      rawVal9 = texture2D(src_tex, st3.zw);\n"
      "\n"
      "      vec4 g1, g2, dg1, dg2;\n"
      "      float  g3, dg3;\n"
      "      g1.x  = rawVal1.x;\n"
      "      dg1.x = rawVal1.y;\n"
      "      g1.y  = rawVal2.x;\n"
      "      dg1.y = rawVal2.y;\n"
      "      g1.z  = rawVal3.x;\n"
      "      dg1.z = rawVal3.y;\n"
      "      g1.w  = rawVal4.x;\n"
      "      dg1.w = rawVal4.y;\n"
      "      g2.x  = rawVal5.x;\n"
      "      dg2.x = rawVal5.y;\n"
      "      g2.y  = rawVal6.x;\n"
      "      dg2.y = rawVal6.y;\n"
      "      g2.z  = rawVal7.x;\n"
      "      dg2.z = rawVal7.y;\n"
      "      g2.w  = rawVal8.x;\n"
      "      dg2.w = rawVal8.y;\n"
      "      g3    = rawVal9.x;\n"
      "      dg3   = rawVal9.y;\n"
      "\n"
      "      float v = dot(f1, g1) + dot(f2, g2);\n"
      "      float dv_dx = -dot(df, g1) + dot(df, vec4(g2.yzw, g3));\n"
      "      float dv_dy = dot(f1, dg1) + dot(f2, dg2);\n"
      "\n"
      "      color.x = v;\n"
      "      color.y = dv_dx;\n"
      "      color.z = dv_dy;\n"
      "   } else if (presmoothing == 2) {\n"
      "      // This is the (odd) binomial kernel [0 1 4 6 4 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 4, 6) / 16.0f;\n"
      "      const vec3 f2 = vec3(4, 1, 0) / 16.0f;\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -4, -5, 0) / 32.0f;\n"
      "      const vec3 df2 = vec3(5, 4, 1) / 32.0f;\n"
      "\n"
      "      vec4 rawVal1, rawVal2, rawVal3, rawVal4, rawVal5, rawVal6, rawVal7;\n"
      "\n"
      "      rawVal1 = texture2D(src_tex, st0.xy);\n"
      "      rawVal2 = texture2D(src_tex, st0.zw);\n"
      "      rawVal3 = texture2D(src_tex, st1.xy);\n"
      "      rawVal4 = texture2D(src_tex, st1.zw);\n"
      "      rawVal5 = texture2D(src_tex, st2.xy);\n"
      "      rawVal6 = texture2D(src_tex, st2.zw);\n"
      "      rawVal7 = texture2D(src_tex, st3.xy);\n"
      "\n"
      "      vec4 g1, dg1;\n"
      "      vec3 g2, dg2;\n"
      "\n"
      "      g1.x  = rawVal1.x;\n"
      "      dg1.x = rawVal1.y;\n"
      "      g1.y  = rawVal2.x;\n"
      "      dg1.y = rawVal2.y;\n"
      "      g1.z  = rawVal3.x;\n"
      "      dg1.z = rawVal3.y;\n"
      "      g1.w  = rawVal4.x;\n"
      "      dg1.w = rawVal4.y;\n"
      "      g2.x  = rawVal5.x;\n"
      "      dg2.x = rawVal5.y;\n"
      "      g2.y  = rawVal6.x;\n"
      "      dg2.y = rawVal6.y;\n"
      "      g2.z  = rawVal7.x;\n"
      "      dg2.z = rawVal7.y;\n"
      "\n"
      "      float v = dot(f1, g1) + dot(f2, g2);\n"
      "      float dv_dx = dot(df1, g1) + dot(df2, g2);\n"
      "      float dv_dy = dot(f1, dg1) + dot(f2, dg2);\n"
      "\n"
      "      color.x = v;\n"
      "      color.y = dv_dx;\n"
      "      color.z = dv_dy;\n"
      "   } else if (presmoothing == 1) {\n"
      "      // This is the (odd) binomial kernel [0 1 2 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 2, 1) / 4.0f;\n"
      "      // Note: f2 = 0.\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -2, 0, 2) / 8.0f;\n"
      "      const float df2 = 1.0 / 8.0f;\n"
      "\n"
      "      vec4 rawVal1, rawVal2, rawVal3, rawVal4, rawVal5;\n"
      "\n"
      "      rawVal1 = texture2D(src_tex, st0.zw);\n"
      "      rawVal2 = texture2D(src_tex, st1.xy);\n"
      "      rawVal3 = texture2D(src_tex, st1.zw);\n"
      "      rawVal4 = texture2D(src_tex, st2.xy);\n"
      "      rawVal5 = texture2D(src_tex, st2.zw);\n"
      "\n"
      "      vec4 g1, dg1;\n"
      "      float  g2, dg2;\n"
      "\n"
      "      g1.x  = rawVal1.x;\n"
      "      dg1.x = rawVal1.y;\n"
      "      g1.y  = rawVal2.x;\n"
      "      dg1.y = rawVal2.y;\n"
      "      g1.z  = rawVal3.x;\n"
      "      dg1.z = rawVal3.y;\n"
      "      g1.w  = rawVal4.x;\n"
      "      dg1.w = rawVal4.y;\n"
      "      g2    = rawVal5.x;\n"
      "      dg2   = rawVal5.y;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv_dx = dot(df1, g1) + df2*g2;\n"
      "      float dv_dy = dot(f1, dg1);\n"
      "\n"
      "      color.x = v;\n"
      "      color.y = dv_dx;\n"
      "      color.z = dv_dy;\n"
      "   } else if (presmoothing == 4) {\n"
      "      // This is the (odd) kernel [0 1 6 1 0]\n"
      "      const vec4 f1 = vec4(0, 1, 6, 1) / 8.0f;\n"
      "      // Note: f2 = 0.\n"
      "\n"
      "      const vec4 df1 = vec4(-1, -6, 0, 6) / 16.0f;\n"
      "      const float df2 = 1.0 / 16.0f;\n"
      "\n"
      "      vec4 rawVal1, rawVal2, rawVal3, rawVal4, rawVal5;\n"
      "\n"
      "      rawVal1 = texture2D(src_tex, st0.zw);\n"
      "      rawVal2 = texture2D(src_tex, st1.xy);\n"
      "      rawVal3 = texture2D(src_tex, st1.zw);\n"
      "      rawVal4 = texture2D(src_tex, st2.xy);\n"
      "      rawVal5 = texture2D(src_tex, st2.zw);\n"
      "\n"
      "      vec4 g1, dg1;\n"
      "      float  g2, dg2;\n"
      "\n"
      "      g1.x  = rawVal1.x;\n"
      "      dg1.x = rawVal1.y;\n"
      "      g1.y  = rawVal2.x;\n"
      "      dg1.y = rawVal2.y;\n"
      "      g1.z  = rawVal3.x;\n"
      "      dg1.z = rawVal3.y;\n"
      "      g1.w  = rawVal4.x;\n"
      "      dg1.w = rawVal4.y;\n"
      "      g2    = rawVal5.x;\n"
      "      dg2   = rawVal5.y;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv_dx = dot(df1, g1) + df2*g2;\n"
      "      float dv_dy = dot(f1, dg1);\n"
      "\n"
      "      color.x = v;\n"
      "      color.y = dv_dx;\n"
      "      color.z = dv_dy;\n"
      "   } else {\n"
      "      // This is the (odd and degenerate) binomial kernel [0 0 1 0 0]\n"
      "      const vec4 f1 = vec4(0, 0, 1, 0);\n"
      "      // Note: f2 = 0.\n"
      "\n"
      "      const vec4 df1 = vec4(0, -1, 0, 1) / 2.0f;\n"
      "\n"
      "      vec4 rawVal1, rawVal2, rawVal3, rawVal4, rawVal5;\n"
      "\n"
      "      rawVal1 = texture2D(src_tex, st0.zw);\n"
      "      rawVal2 = texture2D(src_tex, st1.xy);\n"
      "      rawVal3 = texture2D(src_tex, st1.zw);\n"
      "      rawVal4 = texture2D(src_tex, st2.xy);\n"
      "      rawVal5 = texture2D(src_tex, st2.zw);\n"
      "\n"
      "      vec4 g1;\n"
      "      vec4 dg1;\n"
      "\n"
      "      g1.x  = rawVal1.x;\n"
      "      dg1.x = rawVal1.y;\n"
      "      g1.y  = rawVal2.x;\n"
      "      dg1.y = rawVal2.y;\n"
      "      g1.z  = rawVal3.x;\n"
      "      dg1.z = rawVal3.y;\n"
      "      g1.w  = rawVal4.x;\n"
      "      dg1.w = rawVal4.y;\n"
      "\n"
      "      float v = dot(f1, g1);\n"
      "      float dv_dx = dot(df1, g1);\n"
      "      float dv_dy = dot(f1, dg1);\n"
      "\n"
      "      color.x = v;\n"
      "      color.y = dv_dx;\n"
      "      color.z = dv_dy;\n"
      "   }\n"
      "\n"
      "   my_FragColor.rgb = color;\n"
      "}\n"
      "\n";
   
   const std::string pyramid_with_derivative_pass2 =
      "#version 330\n"
      "\n"
      "uniform sampler2D src_tex;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;\n"
      "\n"
      "void main()\n"
      "{\n"
      "   vec4 st0 = gl_TexCoord[0];\n"
      "   vec4 st1 = gl_TexCoord[1];\n"
      "\n"
      "   vec3 val1 = texture2D(src_tex, st0.xy).xyz;\n"
      "   vec3 val2 = texture2D(src_tex, st0.zw).xyz;\n"
      "   vec3 val3 = texture2D(src_tex, st1.xy).xyz;\n"
      "   vec3 val4 = texture2D(src_tex, st1.zw).xyz;\n"
      "\n"
      "   // This is the (even) binomial kernel [1 3 3 1]\n"
      "   my_FragColor.rgb = (val1 + 3*val2 + 3*val3 + val4) / 8.0f;\n"
      "   //my_FragColor.rgb = (0*val1 + val2 + 2*val3 + val4) / 4.0f;\n"
      "   //my_FragColor.rgb = (val2 + val3) / 2.0f;\n"
      "}\n";

   const std::string tvl1_color_flow_QR_update_uv =
      "#version 330\n"
      "\n"
      "uniform sampler2D uv_src;\n"
      "uniform sampler2D p_uv_src;\n"
      "uniform sampler2D warped_R_tex;\n"
      "uniform sampler2D warped_G_tex;\n"
      "uniform sampler2D warped_B_tex;\n"
      "\n"
      "in vec4 gl_TexCoord[4];\n"
      "\n"
      "out vec4 my_FragColor;"
      "\n"
      "uniform float lambda_theta;\n"
      "uniform float theta;\n"
      "\n"
      "vec3 thresholdingStep(vec3 a2, vec3 b, float lambda_theta)\n"
      "{\n"
      "   vec3 lam_a2 = lambda_theta * a2;\n"
      "   vec3 result;\n"
      "   result.x = (b.x + lam_a2.x < 0) ? lambda_theta : ((b.x - lam_a2.x > 0) ? -lambda_theta : (-b.x/a2.x));\n"
      "   result.y = (b.y + lam_a2.y < 0) ? lambda_theta : ((b.y - lam_a2.y > 0) ? -lambda_theta : (-b.y/a2.y));\n"
      "   result.z = (b.z + lam_a2.z < 0) ? lambda_theta : ((b.z - lam_a2.z > 0) ? -lambda_theta : (-b.z/a2.z));\n"
      "   return result;\n"
      "}\n"
      "\n"
      "void main(void)\n"
      "{\n"
      "   vec2 st0 = gl_TexCoord[0].st;\n"
      "   vec4 stEW = gl_TexCoord[1];\n"
      "   vec4 stSN = gl_TexCoord[2];\n"
      "\n"
      "   vec3 warped_R = texture2D(warped_R_tex, st0).xyz;\n"
      "   vec3 warped_G = texture2D(warped_G_tex, st0).xyz;\n"
      "   vec3 warped_B = texture2D(warped_B_tex, st0).xyz;\n"
      "\n"
      "   // Normalize here to allow lower precision for the warped buffer\n"
      "   warped_R /= 255;\n"
      "   warped_G /= 255;\n"
      "   warped_B /= 255;\n"
      "\n"
      "   vec2 stW = stEW.zw;\n"
      "   vec2 stN = stSN.zw;\n"
      "\n"
      "   bool isLeftBorder   = (stW.x < 0);\n"
      "   bool isRightBorder  = (stEW.x > 1);\n"
      "   bool isTopBorder    = (stN.y < 0);\n"
      "   bool isBottomBorder = (stSN.y > 1);\n"
      "\n"
      "   vec2 uv = texture2D(uv_src, st0).xy;\n"
      "\n"
      "   vec4 p_uv    = texture2D(p_uv_src, st0);\n"
      "   vec2 p1_W_uv = texture2D(p_uv_src, stW).xy;\n"
      "   vec2 p2_N_uv = texture2D(p_uv_src, stN).zw;\n"
      "\n"
      "   p1_W_uv = isLeftBorder   ? vec2(0.0f) : p1_W_uv;\n"
      "   p2_N_uv = isTopBorder    ? vec2(0.0f) : p2_N_uv;\n"
      "   p_uv.xy = isRightBorder  ? vec2(0.0f) : p_uv.xy;\n"
      "   p_uv.zw = isBottomBorder ? vec2(0.0f) : p_uv.zw;\n"
      "\n"
      "   vec2 div_p = p_uv.xy - p1_W_uv + p_uv.zw - p2_N_uv;\n"
      "\n"
      "   // new u and v\n"
      "   vec3 b = vec3(0);\n"
      "   b.x = dot(warped_R, vec3(1, uv));\n"
      "   b.y = dot(warped_G, vec3(1, uv));\n"
      "   b.z = dot(warped_B, vec3(1, uv));\n"
      "\n"
      "   vec3 r2 = vec3(0);\n"
      "   r2.x = dot(warped_R.yz, warped_R.yz);\n"
      "   r2.y = dot(warped_G.yz, warped_G.yz);\n"
      "   r2.z = dot(warped_B.yz, warped_B.yz);\n"
      "\n"
      "   vec3 step = thresholdingStep(r2, b, lambda_theta);\n"
      "\n"
      "   vec2 UV = vec2(0.0f);\n"
      "   UV.x += dot(step, vec3(warped_R.y, warped_G.y, warped_B.y));\n"
      "   UV.y += dot(step, vec3(warped_R.z, warped_G.z, warped_B.z));\n"
      "   UV /= 3.0;\n"
      "   UV += uv;\n"
      "\n"
      "   vec2 uv_out = UV + theta * div_p;\n"
      "\n"
      "   my_FragColor = vec4(uv_out.x, uv_out.y, 0.0f, 0.0f);\n"
      "}\n"
      "\n";
}
