# Find FCLIB includes and libraries.
# The following variables are set if FCLIB is found.  If FCLIB is not
# found, FCLIB_FOUND is set to false.
#  FCLIB_FOUND        - True when the FCLIB include directory is found.
#  FCLIB_INCLUDE_DIRS - the path to where the Siconos FCLIB include files are.
#  FCLIB_LIBRARY_DIRS - The path to where the Siconos library files are.
#  FCLIB_LIBRARIES    - The libraries to link against Siconos FCLIB

# One may want to use a specific FCLIB Library by setting
# FCLIB_LIBRARY_DIRECTORY before FIND_PACKAGE(FCLIB)
INCLUDE(FindPackageHandleStandardArgs)

IF(FCLIB_LIBRARY_DIRECTORY)
  FIND_LIBRARY(FCLIB_LIBRARY fclib PATHS "${FCLIB_LIBRARY_DIRECTORY}")
ELSE(FCLIB_LIBRARY_DIRECTORY)
  FIND_LIBRARY(FCLIB_LIBRARY fclib PATHS ENV LD_LIBRARY_PATH ENV DYLD_LIBRARY_PATH)
ENDIF(FCLIB_LIBRARY_DIRECTORY)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(FCLIB
  REQUIRED_VARS FCLIB_LIBRARY)

IF(FCLIB_LIBRARY)
  GET_FILENAME_COMPONENT(FCLIB_LIBRARY_DIRS ${FCLIB_LIBRARY} PATH)
  SET(FCLIB_LIBRARIES ${FCLIB_LIBRARY} ${FCLIB_COMMON_LIBRARY})
  GET_FILENAME_COMPONENT(FCLIB_LIBRARY_DIRS_DIR ${FCLIB_LIBRARY_DIRS} PATH)
  SET(FCLIB_INCLUDE_DIRS ${FCLIB_LIBRARY_DIRS_DIR}/include)
ELSE(FCLIB_LIBRARY)
  IF(FCLIB_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR
      "Required FCLIB library not found. Please specify library location in FCLIB_LIBRARY_DIRECTORY")
  ENDIF(FCLIB_FIND_REQUIRED)
ENDIF(FCLIB_LIBRARY)
