//
// main.c
// The generic launcher for Shoes.
//
#include <stdio.h>
#include "shoes/app.h"
#include "shoes/ruby.h"
#include "shoes/config.h"
#include "shoes/world.h"
#include "shoes/internal.h"

#ifdef SHOES_WIN32
int WINAPI
WinMain(HINSTANCE inst, HINSTANCE inst2, LPSTR arg, int style)
#else
int
main(argc, argv)
  int argc;
  char *argv[];
#endif
{
  shoes_code code;
  char *path = NULL;
#ifdef SHOES_WIN32
  int argc;
  char **argv;
  argc = shoes_win32_cmdvector(GetCommandLine(), &argv);
#endif

  code = shoes_init();
  if (code != SHOES_OK)
    goto done;

#ifdef SHOES_WIN32
  shoes_world->os.instance = inst;
  shoes_world->os.style = style;
  path = SHOE_ALLOC_N(char, SHOES_BUFSIZE);
  GetModuleFileName(NULL, (LPSTR)path, SHOES_BUFSIZE);
#else
  path = argv[0];
#endif
  shoes_set_argv(argc - 1, &argv[1]);
  code = shoes_start(path, "/");
  if (code != SHOES_OK)
    goto done;

done:
#ifdef SHOES_WIN32
  if (path != NULL)
    SHOE_FREE(path);
#endif
  shoes_final();
  return 0;
}
