/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file services.h
   \brief Provides all kind of service functions. Cannot be linked from libcubew.a.
 */
#ifndef CUBEW_SERVICES_H
#define CUBEW_SERVICES_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdint.h>
#include "cubew_cube.h"
#include "cubew_metric.h"
#include "cubew_types.h"

/*          public part  */
char*
services_escape_to_xml( char* str );
void
print_bit_string( char*    bitstring,
                  unsigned size );
void
print_row( void*    row,
           unsigned size );

/*     private part, should be not calles "standalone      */
enum DataType
__cube_metric_dtype2data_type( const char* dtype );
int
__cube_metric_size_dtype( enum DataType dtype );
char*
__cube_metric_dtype2string( enum DataType dtype );

uint32_t
__cube_metric_bit_position( char*    bit_vector,
                            unsigned vlen,
                            int      cid );
uint32_t
__cube_metric_size_of_index( char*    bit_vector,
                             unsigned vlen );
uint32_t*
__cube_metric_create_index( char*    bit_vector,
                            unsigned vlen );
unsigned
__is_bit_set( char* bit_vector,
              int   bitposition );
void
__set_bit( char* bit_vector,
           int   bitposition );

int
/* -1 shows empty bitstring */
__cube_metric_last_bit_position( char*    bit_vector,
                                 unsigned vlen
                                 );


uint64_t*
__transform_doubles_into_uint64( double*  data_row,
                                 uint32_t size );
double*
__transform_uint64_into_doubles( uint64_t* data_row,
                                 uint32_t  size );
enum value_compat_t
__cube_type_compatibility_check( enum DataType from,
                                 enum DataType to );

void*
__transform_row_of_values( enum     DataType,
                           enum     DataType,
                           void*    sevs,
                           uint32_t size );

void
__cube_value_transform( enum DataType from,
                        enum DataType to,
                        char*         target_place_for_value,
                        void*         source,
                        uint32_t      to_sizeof,
                        uint32_t      from_sizeof );

void*
__get_init_value( enum DataType     datatype,
                  enum value_init_t sort_of_value,
                  void*             value );

void
__initialize_row_of_memory( enum DataType     datatype,
                            enum value_init_t sort_of_value,
                            void*,
                            uint64_t          size,
                            void*             value );                                                                    /* size -> in bytes */

void*
__get_zero_row( enum DataType datatype,
                uint64_t      size );                  /* size -> in bytes */

void*
__get_undefined_row( enum DataType datatype,
                     uint64_t      size );                  /* size -> in bytes */

void*
__get_valued_row( enum DataType datatype,
                  uint64_t      size,
                  void*         value );                               /* size -> in bytes */





char*
cubew_strdup( const char* str );


void
__create_path_for_file( char* path );


/* Our cube wrapper the POSIX fseeko implementation, because it is not available in
   C99 be default.  */
int
cubew_fseeko( FILE*    stream,
              uint64_t offset,
              int      whence );


#ifdef __cplusplus
}
#endif

#endif
