/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file cubew_report_layouts.h
 * \brief Includes proper combinatins of file layout and name transformations according to the choosen (via macro) report layout.
 *
 *
 *
 */

#ifndef __CUBEW_REPORT_LAYOUTS_H
#define __CUBEW_REPORT_LAYOUTS_H 0

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
// #include "cubew_cubew.h"


#ifdef CUBE_LAYOUT_TAR
#ifdef CUBE_LAYOUT_DIRECT
#error Only one layout has to be choosen. Either "tar" via macro CUBE_LAYOUT_TAR or "direct" via macro CUBE_LAYOUT_DIRECT
#endif
#ifndef CUBE_LAYOUT_DIRECT

// #warning "TAR LAYOUT!"

#include "cubew_file_layout_embedded.h"
#include "cubew_tar_writing.h"

#endif
#endif


#ifdef CUBE_LAYOUT_DIRECT

#ifdef CUBE_LAYOUT_TAR
#error Only one layout has to be choosen. Either "tar" via macro CUBE_LAYOUT_TAR or "direct" via macro CUBE_LAYOUT_DIRECT
#endif

#ifndef CUBE_LAYOUT_TAR

// #warning "DIRECT HYBRID LAYOUT!"

#include "cubew_file_layout_hybrid.h"
#include "cubew_direct_writing.h"

#endif

#endif


#ifndef CUBE_LAYOUT_DIRECT
#ifndef CUBE_LAYOUT_TAR
// default includes are
// #warning "DEFUALT LAYOUT! "
#include "cubew_file_layout_embedded.h"
#include "cubew_tar_writing.h"
#endif
#endif


#endif
