/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file cubew_file_layout_hybrid.c
 * \brief Provides names for avery part of cube report according to the "hybrid layout: [cubename].cubex + [cubename].cubex.data/[metic uniw name].index, [metric uniq name].data
 *
 *
 */

#ifndef __CUBEW_FILE_LAYOUT_HYBRID_C
#define __CUBEW_FILE_LAYOUT_HYBRID_C 0

#include <config.h>
#include "cubew_file_layout_hybrid.h"

/**
 *
 */



char*
cube_get_path_to_anchor( const char* cubename )
{
    unsigned namelen = strlen( cubename ) + strlen( ".cubex" );
    char     buf[ namelen ];
    memset( buf, 0, namelen );
    sprintf( buf, "%s.cubex", cubename );
    char* to_return = cubew_strdup( buf );
    return to_return;
}

char*
cube_get_path_to_metric_data( const char* cubename,  cube_metric* met )
{
    char*    metname = cube_metric_get_uniq_name( met );
    unsigned namelen = strlen( cubename ) + strlen( ".cubex.data/" ) + strlen( metname ) + strlen( ".data" );
    char     buf[ namelen ];
    memset( buf, 0, namelen );
    sprintf( buf, "%s.cubex.data/%s.data", cubename, metname );
    char* to_return = cubew_strdup( buf );
    return to_return;
}


char*
cube_get_path_to_metric_index( const char* cubename,   cube_metric* met )
{
    char*    metname = cube_metric_get_uniq_name( met );
    unsigned namelen = strlen( cubename ) + strlen( ".cubex.data/" ) + strlen( metname ) + strlen( ".index" );
    char     buf[ namelen ];
    memset( buf, 0, namelen );
    sprintf( buf, "%s.cubex.data/%s.index", cubename, metname );
    char* to_return = cubew_strdup( buf );
    return to_return;
}
char*
cube_get_path_to_misc_data( const char* cubename,  const char* dataname )
{
    char*    metname = cube_metric_get_uniq_name( met );
    unsigned namelen = strlen( cubename ) + strlen( ".cubex.data/" ) + strlen( dataname );
    char     buf[ namelen ];
    memset( buf, 0, namelen );
    sprintf( buf, "%s.cubex.data/%s", cubename, dataname );
    char* to_return = cubew_strdup( buf );
    return to_return;
}

#endif
