/****************************************************************************
**  CUBE        http://www.score-p.org/                                    **
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/
/**
 * \file cubew_direct_writing.h
 * \brief Provides a fooled file name transformation scheme: name -> name, withot any changes. Produces direct manyfile writing of cube report
 *
 *
 *
 */

#ifndef __CUBEW_DIRECT_WRITING_H
#define __CUBEW_DIRECT_WRITING_H 0

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "cubew_metric.h"
#include "cubew_report_layouts.h"



typedef struct direct_writer_t
{
    char*               cubename;
    cube_metric*        actual_metric;
    enum CubeFlavours_t cube_flavour;
} __attribute__ ( ( __packed__ ) )  direct_writer_t;


// typedef direct_writer_t report_layout_writer;


/*
   FILE * cube_get_anchor_file_name( char * cubename);
   FILE * cube_get_metric_data_file( char * cubename,  cube_metric * met);
   FILE * cube_get_metric_index_file( char * cubename,  cube_metric * met);*/

// void cube_report_finish();

FILE*
cube_report_anchor_start( report_layout_writer* rlw );
FILE*
cube_report_metric_data_start( report_layout_writer* rlw,
                               cube_metric*          met );
FILE*
cube_report_metric_index_start( report_layout_writer* rlw,
                                cube_metric*          met );
FILE*
cube_report_misc_data_start( report_layout_writer* rlw,
                             const char*           dataname );

void
cube_report_anchor_finish( report_layout_writer* rlw,
                           FILE*                 file );
void
cube_report_metric_data_finish( report_layout_writer* rlw,
                                cube_metric*          met,
                                FILE*                 file );
void
cube_report_misc_data_finish( report_layout_writer* rlw,
                              FILE*                 file );
void
cube_report_metric_data_weak_finish( report_layout_writer* rlw,
                                     cube_metric*          met,
                                     FILE*                 file );
void
cube_report_metric_index_finish( report_layout_writer* rlw,
                                 cube_metric*          met,
                                 FILE*                 file );

void
cube_report_write_metric_row( report_layout_writer* rlw,
                              cube_metric*          met );

report_layout_writer*
cube_writing_start( char*               cubename,
                    enum CubeFlavours_t cf );
report_layout_writer*
cube_writing_end( report_layout_writer* rlw );


#endif
