/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>

#include <cstddef>

#include <pearl/Callpath.h>
#include <pearl/Callsite.h>
#include <pearl/Communicator.h>
#include <pearl/Location.h>
#include <pearl/ProcessGroup.h>
#include <pearl/Region.h>
#include <pearl/String.h>
#include <pearl/SystemNode.h>


using namespace std;
using namespace pearl;


/*-------------------------------------------------------------------------*/
/**
 *  @file    pearl_statics.cpp
 *  @ingroup PEARL_base
 *  @brief   Definition of all static objects.
 *
 *  This file provides the definition of all static objects to ensure a
 *  proper initialization order.
 **/
/*-------------------------------------------------------------------------*/

//--- Static class data -----------------------------------------------------

const String::IdType String::NO_ID;
const String         String::UNDEFINED(String::NO_ID,
                                       "");

const String::IdType String::MACHINE_ID;
const String         String::MACHINE(String::MACHINE_ID,
                                     "machine");

const String::IdType String::NODE_ID;
const String         String::NODE(String::NODE_ID,
                                  "node");

const Region::IdType Region::NO_ID;
const Region         Region::UNDEFINED(Region::NO_ID,
                                       String::UNDEFINED,
                                       String::UNDEFINED,
                                       String::UNDEFINED,
                                       Region::ROLE_UNKNOWN,
                                       Region::PARADIGM_UNKNOWN,
                                       String::UNDEFINED,
                                       0,
                                       0);

const Callsite::IdType Callsite::NO_ID;
const Callsite         Callsite::UNDEFINED(Callsite::NO_ID,
                                           String::UNDEFINED,
                                           0,
                                           Region::UNDEFINED);

const Callpath::IdType Callpath::NO_ID;
const Callpath         Callpath::UNDEFINED(Callpath::NO_ID,
                                           Region::UNDEFINED,
                                           Callsite::UNDEFINED,
                                           NULL);

const ProcessGroup::IdType ProcessGroup::NO_ID;
const ProcessGroup         ProcessGroup::UNDEFINED(ProcessGroup::NO_ID,
                                                   String::UNDEFINED,
                                                   RankContainer(),
                                                   true,
                                                   true);

const Communicator::IdType Communicator::NO_ID;
const Communicator         Communicator::UNDEFINED(Communicator::NO_ID,
                                                   String::UNDEFINED,
                                                   ProcessGroup::UNDEFINED,
                                                   NULL);

const Location::IdType Location::NO_ID;
const Location         Location::UNDEFINED(Location::NO_ID,
                                           String::UNDEFINED,
                                           Location::TYPE_UNKNOWN,
                                           0,
                                           NULL);

const SystemNode::IdType SystemNode::NO_ID;
const SystemNode         SystemNode::UNDEFINED(SystemNode::NO_ID,
                                               String::UNDEFINED,
                                               String::UNDEFINED,
                                               NULL);
