/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_OMPEVENTFACTORY_H
#define PEARL_OMPEVENTFACTORY_H


#include "EventFactory.h"


/*-------------------------------------------------------------------------*/
/**
 *  @file    OmpEventFactory.h
 *  @ingroup PEARL_omp
 *  @brief   Declaration of the class OmpEventFactory.
 *
 *  This header file provides the declaration of the class OmpEventFactory.
 **/
/*-------------------------------------------------------------------------*/


namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   OmpEventFactory
 *  @ingroup PEARL_omp
 *  @brief   Abstract factory class for OMP-specific event representations.
 **/
/*-------------------------------------------------------------------------*/


class OmpEventFactory : virtual public EventFactory
{
  public:
    /// @name OMP specific factory methods
    /// @{

    virtual Event_rep* createOmpFork        (const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint32_t          teamSize) const;
    virtual Event_rep* createOmpJoin        (const GlobalDefs& defs,
                                             timestamp_t       time) const;
    virtual Event_rep* createOmpAcquireLock (const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint32_t          lockId,
                                             uint32_t          order) const;
    virtual Event_rep* createOmpReleaseLock (const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint32_t          lockId,
                                             uint32_t          order) const;
    virtual Event_rep* createOmpTaskCreate  (const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint64_t          taskId) const;
    virtual Event_rep* createOmpTaskComplete(const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint64_t          taskId) const;
    virtual Event_rep* createOmpTaskSwitch  (const GlobalDefs& defs,
                                             timestamp_t       time,
                                             uint64_t          taskId) const;

    /// @}
    /// @name Buffer-based factory methods
    /// @{

    virtual Event_rep* createEvent(event_t           type,
                                   const GlobalDefs& defs,
                                   Buffer&           buffer) const;

    /// @}
};


}   // namespace pearl


#endif   // !PEARL_OMPEVENTFACTORY_H
