/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_RMAGETEND_REP_H
#define PEARL_RMAGETEND_REP_H


#include <pearl/Event_rep.h>


/*-------------------------------------------------------------------------*/
/**
 *  @file    RmaGetEnd_rep.h
 *  @ingroup PEARL_base
 *  @brief   Declaration of the class RmaGetEnd_rep.
 *
 *  This header file provides the declaration of the class RmaGetEnd_rep.
 **/
/*-------------------------------------------------------------------------*/


namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @internal
 *
 *  @class   RmaGetEnd_rep
 *  @ingroup PEARL_base
 *  @brief   %Event representation for RMA_GET_END events.
 **/
/*-------------------------------------------------------------------------*/

class PEARL_NOPAD_ATTR RmaGetEnd_rep : public Event_rep
{
  public:
    /// @name Constructors & destructor
    /// @{

    RmaGetEnd_rep(timestamp_t timestamp,
                  uint32_t    rma_id);
    RmaGetEnd_rep(const GlobalDefs& defs, Buffer& buffer);

    /// @}
    /// @name Event type information
    /// @{

    virtual event_t getType() const;
    virtual bool    isOfType(event_t type) const;

    /// @}
    /// @name Access event data
    /// @{

    virtual uint32_t get_rma_id() const;

    /// @}


  protected:
    /// @name Serialize event data
    /// @{

    virtual void pack(Buffer& buffer) const;

    /// @}
    /// @name Generate human-readable output of event data
    /// @{

    virtual std::ostream& output(std::ostream& stream) const;

    /// @}


  private:
    /// RMA ID
    uint32_t m_rma_id;
};


}   // namespace pearl


#endif   // !PEARL_RMAGETEND_REP_H
