/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_OMPTASKCOMPLETE_REP_H
#define PEARL_OMPTASKCOMPLETE_REP_H


#include <pearl/Event_rep.h>


/*-------------------------------------------------------------------------*/
/**
 *  @file    OmpTaskComplete_rep.h
 *  @ingroup PEARL_omp
 *  @brief   Declaration of the class OmpTaskComplete_rep.
 *
 *  This header file provides the declaration of the class OmpTaskComplete_rep.
 **/
/*-------------------------------------------------------------------------*/


namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   OmpTaskComplete_rep
 *  @ingroup PEARL_omp
 *  @brief   %Event representation for OMP_TASK_COMPLETE events.
 **/
/*-------------------------------------------------------------------------*/

class PEARL_NOPAD_ATTR OmpTaskComplete_rep : public Event_rep
{
  public:
    /// @name Constructors & destructor
    /// @{

    OmpTaskComplete_rep(timestamp_t timestamp, uint64_t taskId);
    OmpTaskComplete_rep(const GlobalDefs& defs, Buffer& buffer);

    /// @}
    /// @name Event type information
    /// @{

    virtual event_t getType() const;
    virtual bool    isOfType(event_t type) const;

    /// @}
    /// @name Access event data
    /// @{

    uint64_t getTaskId() const;

    /// @}


  protected:
    /// @name Generate human-readable output of event data
    /// @{

    virtual std::ostream& output(std::ostream& stream) const;

    /// @}


  private:
    /// Task identifier
    uint64_t mTaskId;
};


}   // namespace pearl


#endif   // !PEARL_OMPTASKCOMPLETE_REP_H
