/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_OMPFORK_REP_H
#define PEARL_OMPFORK_REP_H


#include <pearl/Event_rep.h>


/*-------------------------------------------------------------------------*/
/**
 *  @file    OmpFork_rep.h
 *  @ingroup PEARL_omp
 *  @brief   Declaration of the class OmpFork_rep.
 *
 *  This header file provides the declaration of the class OmpFork_rep.
 **/
/*-------------------------------------------------------------------------*/


namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   OmpFork_rep
 *  @ingroup PEARL_omp
 *  @brief   %Event representation for OMP_FORK events.
 **/
/*-------------------------------------------------------------------------*/

class PEARL_NOPAD_ATTR OmpFork_rep : public Event_rep
{
  public:
    /// @name Constructors & destructor
    /// @{

    OmpFork_rep(timestamp_t timestamp, uint32_t teamSize);
    OmpFork_rep(const GlobalDefs& defs, Buffer& buffer);

    /// @}
    /// @name Event type information
    /// @{

    virtual event_t getType() const;
    virtual bool    isOfType(event_t type) const;

    /// @}
    /// @name Access event data
    /// @{

    uint32_t getTeamSize() const;

    /// @}


  protected:
    /// @name Serialize event data
    /// @{

    virtual void pack(Buffer& buffer) const;

    /// @}
    /// @name Generate human-readable output of event data
    /// @{

    virtual std::ostream& output(std::ostream& stream) const;

    /// @}


  private:
    /// Requested thread team size
    uint32_t mTeamSize;
};


}   // namespace pearl


#endif   // !PEARL_OMPFORK_REP_H
