/* rygel-dtcp-cleartext-request.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-dtcp-cleartext-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;
typedef struct _RygelDTCPCleartextRequestPrivate RygelDTCPCleartextRequestPrivate;
enum  {
	RYGEL_DTCP_CLEARTEXT_REQUEST_0_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_NUM_PROPERTIES];

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelDTCPCleartextRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelDTCPCleartextRequestPrivate * priv;
};

struct _RygelDTCPCleartextRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelDTCPCleartextRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

static gint RygelDTCPCleartextRequest_private_offset;
static gpointer rygel_dtcp_cleartext_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPSeekRequest, g_object_unref)
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDTCPCleartextRequest, g_object_unref)
#define RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER "Range.dtcp.com"
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPGetHandler, g_object_unref)
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (SoupMessage* message,
                                                             RygelHTTPGetHandler* handler,
                                                             GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type,
                                                                   SoupMessage* message,
                                                                   RygelHTTPGetHandler* handler,
                                                                   GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPMediaResourceHandler, g_object_unref)
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaResource, g_object_unref)
GType rygel_http_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPRequest, g_object_unref)
GType rygel_http_get_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPGet, g_object_unref)
GType rygel_http_response_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPResponse, g_object_unref)
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self,
                                                  gint64 value);
static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self,
                                                gint64 value);
static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self,
                                                    gint64 value);
static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self,
                                                  gint64 value);
gboolean rygel_dtcp_cleartext_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_dtcp_cleartext_request_requested (SoupMessage* message);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self);
static void rygel_dtcp_cleartext_request_finalize (GObject * obj);
static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_dtcp_cleartext_request_get_instance_private (RygelDTCPCleartextRequest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDTCPCleartextRequest_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}

RygelDTCPCleartextRequest*
rygel_dtcp_cleartext_request_construct (GType object_type,
                                        SoupMessage* message,
                                        RygelHTTPGetHandler* handler,
                                        GError** error)
{
	RygelDTCPCleartextRequest * self = NULL;
	gint64 start = 0LL;
	gint64 end = 0LL;
	gint64 total_size = 0LL;
	const gchar* range = NULL;
	SoupMessageHeaders* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp11_;
	gchar** range_tokens = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gint range_tokens_length1;
	gint _range_tokens_size_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	gint64 _tmp31_ = 0LL;
	gboolean _tmp32_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gint64 _tmp59_ = 0LL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelDTCPCleartextRequest*) rygel_http_seek_request_construct (object_type);
	if (G_TYPE_CHECK_INSTANCE_TYPE (handler, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelMediaResource* resource = NULL;
		RygelMediaResource* _tmp0_;
		RygelMediaResource* _tmp1_;
		RygelMediaResource* _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		_tmp0_ = (G_TYPE_CHECK_INSTANCE_TYPE (handler, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) handler) : NULL)->media_resource;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		resource = _tmp1_;
		_tmp2_ = resource;
		_tmp3_ = rygel_media_resource_get_cleartext_size (_tmp2_);
		_tmp4_ = _tmp3_;
		total_size = _tmp4_;
		if (total_size <= ((gint64) 0)) {
			total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		}
		_g_object_unref0 (resource);
	} else {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp5_ = message->request_headers;
	_tmp6_ = soup_message_headers_get_one (_tmp5_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	range = _tmp6_;
	_tmp7_ = range;
	if (_tmp7_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp8_ = g_strdup ("%s request header not present");
		msg = _tmp8_;
		_tmp9_ = msg;
		_tmp10_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp9_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
		_inner_error0_ = _tmp10_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp11_ = range;
	if (!g_str_has_prefix (_tmp11_, "bytes")) {
		gchar* msg = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp12_ = g_strdup ("Invalid %s value (missing bytes field): '%s'");
		msg = _tmp12_;
		_tmp13_ = msg;
		_tmp14_ = range;
		_tmp15_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp13_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp14_);
		_inner_error0_ = _tmp15_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp16_ = range;
	_tmp17_ = string_substring (_tmp16_, (glong) 6, (glong) -1);
	_tmp18_ = _tmp17_;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "-", 2);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _vala_array_length (_tmp19_);
	_g_free0 (_tmp18_);
	range_tokens = _tmp21_;
	range_tokens_length1 = _tmp21__length1;
	_range_tokens_size_ = range_tokens_length1;
	_tmp22_ = range_tokens[0];
	_tmp23_ = strlen (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == 0) {
		gchar* msg = NULL;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		GError* _tmp28_;
		_tmp25_ = g_strdup ("No range start specified: '%s'");
		msg = _tmp25_;
		_tmp26_ = msg;
		_tmp27_ = range;
		_tmp28_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp26_, _tmp27_);
		_inner_error0_ = _tmp28_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp30_ = range_tokens[0];
	_tmp32_ = int64_try_parse (_tmp30_, &_tmp31_, NULL);
	start = _tmp31_;
	if (!_tmp32_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = start < ((gint64) 0);
	}
	if (_tmp29_) {
		gchar* msg = NULL;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		GError* _tmp36_;
		_tmp33_ = g_strdup ("Invalid %s range start: '%s'");
		msg = _tmp33_;
		_tmp34_ = msg;
		_tmp35_ = range;
		_tmp36_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp34_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp35_);
		_inner_error0_ = _tmp36_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp37_ = range_tokens[1];
	_tmp38_ = strlen (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == 0) {
		end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gboolean _tmp40_ = FALSE;
		const gchar* _tmp41_;
		gint64 _tmp42_ = 0LL;
		gboolean _tmp43_;
		_tmp41_ = range_tokens[1];
		_tmp43_ = int64_try_parse (_tmp41_, &_tmp42_, NULL);
		end = _tmp42_;
		if (!_tmp43_) {
			_tmp40_ = TRUE;
		} else {
			_tmp40_ = end <= ((gint64) 0);
		}
		if (_tmp40_) {
			gchar* msg = NULL;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			GError* _tmp47_;
			_tmp44_ = g_strdup ("Invalid %s range end: '%s'");
			msg = _tmp44_;
			_tmp45_ = msg;
			_tmp46_ = range;
			_tmp47_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp45_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp46_);
			_inner_error0_ = _tmp47_;
			if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (msg);
		}
	}
	if (end != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp48_ = start > end;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gchar* msg = NULL;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		GError* _tmp52_;
		_tmp49_ = g_strdup ("Invalid %s range - start > end: '%s'");
		msg = _tmp49_;
		_tmp50_ = msg;
		_tmp51_ = range;
		_tmp52_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp50_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp51_);
		_inner_error0_ = _tmp52_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp53_ = start > (total_size - 1);
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		gchar* msg = NULL;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		GError* _tmp57_;
		_tmp54_ = g_strdup ("Invalid %s range - start > length: '%s'");
		msg = _tmp54_;
		_tmp55_ = msg;
		_tmp56_ = range;
		_tmp57_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp55_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp56_);
		_inner_error0_ = _tmp57_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp58_ = end > (total_size - 1);
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		end = total_size - 1;
	}
	rygel_dtcp_cleartext_request_set_start_byte (self, start);
	rygel_dtcp_cleartext_request_set_end_byte (self, end);
	if (end == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp59_ = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		_tmp59_ = (end - start) + 1;
	}
	rygel_dtcp_cleartext_request_set_range_length (self, _tmp59_);
	rygel_dtcp_cleartext_request_set_total_size (self, total_size);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

RygelDTCPCleartextRequest*
rygel_dtcp_cleartext_request_new (SoupMessage* message,
                                  RygelHTTPGetHandler* handler,
                                  GError** error)
{
	return rygel_dtcp_cleartext_request_construct (RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, message, handler, error);
}

gboolean
rygel_dtcp_cleartext_request_supported (SoupMessage* message,
                                        RygelHTTPGetHandler* handler)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (handler, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
		RygelMediaResource* _tmp1_;
		_tmp1_ = (G_TYPE_CHECK_INSTANCE_TYPE (handler, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) handler) : NULL)->media_resource;
		_tmp0_ = rygel_media_resource_is_cleartext_range_support_enabled (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
rygel_dtcp_cleartext_request_requested (SoupMessage* message)
{
	gboolean result = FALSE;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	result = _tmp1_ != NULL;
	return result;
}

gint64
rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self,
                                             gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dtcp_cleartext_request_get_start_byte (self) != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self,
                                           gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dtcp_cleartext_request_get_end_byte (self) != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self,
                                               gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dtcp_cleartext_request_get_range_length (self) != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self,
                                             gint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_dtcp_cleartext_request_get_total_size (self) != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY]);
	}
}

static void
rygel_dtcp_cleartext_request_class_init (RygelDTCPCleartextRequestClass * klass,
                                         gpointer klass_data)
{
	rygel_dtcp_cleartext_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDTCPCleartextRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_request_finalize;
	/**
	     * The start of the cleartext range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The end of the cleartext range in bytes (inclusive). May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the cleartext range in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the cleartext resource in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_dtcp_cleartext_request_instance_init (RygelDTCPCleartextRequest * self,
                                            gpointer klass)
{
	self->priv = rygel_dtcp_cleartext_request_get_instance_private (self);
}

static void
rygel_dtcp_cleartext_request_finalize (GObject * obj)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	G_OBJECT_CLASS (rygel_dtcp_cleartext_request_parent_class)->finalize (obj);
}

GType
rygel_dtcp_cleartext_request_get_type (void)
{
	static volatile gsize rygel_dtcp_cleartext_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextRequest), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_request_instance_init, NULL };
		GType rygel_dtcp_cleartext_request_type_id;
		rygel_dtcp_cleartext_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDTCPCleartextRequest", &g_define_type_info, 0);
		RygelDTCPCleartextRequest_private_offset = g_type_add_instance_private (rygel_dtcp_cleartext_request_type_id, sizeof (RygelDTCPCleartextRequestPrivate));
		g_once_init_leave (&rygel_dtcp_cleartext_request_type_id__volatile, rygel_dtcp_cleartext_request_type_id);
	}
	return rygel_dtcp_cleartext_request_type_id__volatile;
}

static void
_vala_rygel_dtcp_cleartext_request_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_start_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_end_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_range_length (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_dtcp_cleartext_request_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY:
		rygel_dtcp_cleartext_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY:
		rygel_dtcp_cleartext_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY:
		rygel_dtcp_cleartext_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY:
		rygel_dtcp_cleartext_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

