/* rygel-plugin-information.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-plugin-information.vala, do not modify */

/*
 * Copyright (C) 2013 Jens Georg.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#define RYGEL_TYPE_PLUGIN_INFORMATION (rygel_plugin_information_get_type ())
#define RYGEL_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation))
#define RYGEL_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))
#define RYGEL_IS_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_IS_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_PLUGIN_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))

typedef struct _RygelPluginInformation RygelPluginInformation;
typedef struct _RygelPluginInformationClass RygelPluginInformationClass;
typedef struct _RygelPluginInformationPrivate RygelPluginInformationPrivate;
enum  {
	RYGEL_PLUGIN_INFORMATION_0_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY,
	RYGEL_PLUGIN_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelPluginInformation {
	GObject parent_instance;
	RygelPluginInformationPrivate * priv;
};

struct _RygelPluginInformationClass {
	GObjectClass parent_class;
};

struct _RygelPluginInformationPrivate {
	gchar* _module_path;
	gchar* _name;
};

static gint RygelPluginInformation_private_offset;
static gpointer rygel_plugin_information_parent_class = NULL;

GType rygel_plugin_information_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPluginInformation, g_object_unref)
static RygelPluginInformation* rygel_plugin_information_new (const gchar* module_path,
                                                      const gchar* name);
static RygelPluginInformation* rygel_plugin_information_construct (GType object_type,
                                                            const gchar* module_path,
                                                            const gchar* name);
RygelPluginInformation* rygel_plugin_information_new_from_file (GFile* file,
                                                                GError** error);
const gchar* rygel_plugin_information_get_module_path (RygelPluginInformation* self);
static void rygel_plugin_information_set_module_path (RygelPluginInformation* self,
                                               const gchar* value);
const gchar* rygel_plugin_information_get_name (RygelPluginInformation* self);
static void rygel_plugin_information_set_name (RygelPluginInformation* self,
                                        const gchar* value);
static void rygel_plugin_information_finalize (GObject * obj);
static void _vala_rygel_plugin_information_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_rygel_plugin_information_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
rygel_plugin_information_get_instance_private (RygelPluginInformation* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPluginInformation_private_offset);
}

static RygelPluginInformation*
rygel_plugin_information_construct (GType object_type,
                                    const gchar* module_path,
                                    const gchar* name)
{
	RygelPluginInformation * self = NULL;
	g_return_val_if_fail (module_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelPluginInformation*) g_object_new (object_type, "module-path", module_path, "name", name, NULL);
	return self;
}

static RygelPluginInformation*
rygel_plugin_information_new (const gchar* module_path,
                              const gchar* name)
{
	return rygel_plugin_information_construct (RYGEL_TYPE_PLUGIN_INFORMATION, module_path, name);
}

/**
     * Factory method to create a #RygelPluginInformation from #GFile.
     *
     * @param file a #GFile pointing to the sidecar file
     * @return A new instance of #RygelPluginInformation
     */
RygelPluginInformation*
rygel_plugin_information_new_from_file (GFile* file,
                                        GError** error)
{
	RygelPluginInformation* result = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GKeyFile* _tmp4_;
	gchar* name = NULL;
	GKeyFile* _tmp6_;
	gchar* _tmp7_;
	gchar* module = NULL;
	GKeyFile* _tmp8_;
	gchar* _tmp9_;
	GFile* module_dir = NULL;
	GFile* _tmp10_;
	GFile* module_file = NULL;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	RygelPluginInformation* _tmp33_;
	RygelPluginInformation* _tmp34_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = keyfile;
	_tmp2_ = g_file_get_path (file);
	_tmp3_ = _tmp2_;
	g_key_file_load_from_file (_tmp1_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp4_ = keyfile;
	if (!g_key_file_has_group (_tmp4_, "Plugin")) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND, _ ("[Plugin] group not found"));
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp6_ = keyfile;
	_tmp7_ = g_key_file_get_string (_tmp6_, "Plugin", "Name", &_inner_error0_);
	name = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp8_ = keyfile;
	_tmp9_ = g_key_file_get_string (_tmp8_, "Plugin", "Module", &_inner_error0_);
	module = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_key_file_unref0 (keyfile);
		return NULL;
	}
	_tmp10_ = g_file_get_parent (file);
	module_dir = _tmp10_;
	_tmp11_ = module_dir;
	_tmp12_ = module;
	_tmp13_ = g_strdup_printf ("librygel-%s.%s", _tmp12_, G_MODULE_SUFFIX);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_child (_tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	module_file = _tmp16_;
	_tmp17_ = module_file;
	if (!g_file_query_exists (_tmp17_, NULL)) {
		GFile* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		_tmp18_ = module_dir;
		_tmp19_ = module;
		_tmp20_ = g_strdup_printf (".libs%clibrygel-%s.%s", (gint) G_DIR_SEPARATOR, _tmp19_, G_MODULE_SUFFIX);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_get_child (_tmp18_, _tmp21_);
		_g_object_unref0 (module_file);
		module_file = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp23_ = module_file;
		if (!g_file_query_exists (_tmp23_, NULL)) {
			GFile* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GError* _tmp27_;
			GError* _tmp28_;
			_tmp24_ = module_file;
			_tmp25_ = g_file_get_path (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_EXIST, _ ("Plugin module %s does not exist"), _tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp26_);
			_inner_error0_ = _tmp28_;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (module_file);
			_g_object_unref0 (module_dir);
			_g_free0 (module);
			_g_free0 (name);
			_g_key_file_unref0 (keyfile);
			return NULL;
		}
	}
	_tmp29_ = module_file;
	_tmp30_ = g_file_get_path (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = name;
	_tmp33_ = rygel_plugin_information_new (_tmp31_, _tmp32_);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp31_);
	result = _tmp34_;
	_g_object_unref0 (module_file);
	_g_object_unref0 (module_dir);
	_g_free0 (module);
	_g_free0 (name);
	_g_key_file_unref0 (keyfile);
	return result;
}

const gchar*
rygel_plugin_information_get_module_path (RygelPluginInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_path;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_information_set_module_path (RygelPluginInformation* self,
                                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_information_get_module_path (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_module_path);
		self->priv->_module_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY]);
	}
}

const gchar*
rygel_plugin_information_get_name (RygelPluginInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_information_set_name (RygelPluginInformation* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_plugin_information_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY]);
	}
}

static void
rygel_plugin_information_class_init (RygelPluginInformationClass * klass,
                                     gpointer klass_data)
{
	rygel_plugin_information_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPluginInformation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_information_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_information_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_information_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY] = g_param_spec_string ("module-path", "module-path", "module-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY, rygel_plugin_information_properties[RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
rygel_plugin_information_instance_init (RygelPluginInformation * self,
                                        gpointer klass)
{
	self->priv = rygel_plugin_information_get_instance_private (self);
}

static void
rygel_plugin_information_finalize (GObject * obj)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	_g_free0 (self->priv->_module_path);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (rygel_plugin_information_parent_class)->finalize (obj);
}

/**
 * Parse plugin sidecar file and provide path to the module.
 *
 * Sidecar files are keyfiles, loosely compatible with the files used by
 * libpeas.
 *
 * A minimal file for the plugin librygel-sompelugin.so looks like this:
 *
 * [Plugin]
 * Name = SomeNameForThePlugin
 * Module = someplugin
 *
 * Name must not contain any whitespaces.
 */
GType
rygel_plugin_information_get_type (void)
{
	static volatile gsize rygel_plugin_information_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_information_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginInformation), 0, (GInstanceInitFunc) rygel_plugin_information_instance_init, NULL };
		GType rygel_plugin_information_type_id;
		rygel_plugin_information_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginInformation", &g_define_type_info, 0);
		RygelPluginInformation_private_offset = g_type_add_instance_private (rygel_plugin_information_type_id, sizeof (RygelPluginInformationPrivate));
		g_once_init_leave (&rygel_plugin_information_type_id__volatile, rygel_plugin_information_type_id);
	}
	return rygel_plugin_information_type_id__volatile;
}

static void
_vala_rygel_plugin_information_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	switch (property_id) {
		case RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY:
		g_value_set_string (value, rygel_plugin_information_get_module_path (self));
		break;
		case RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY:
		g_value_set_string (value, rygel_plugin_information_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_plugin_information_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	RygelPluginInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation);
	switch (property_id) {
		case RYGEL_PLUGIN_INFORMATION_MODULE_PATH_PROPERTY:
		rygel_plugin_information_set_module_path (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_INFORMATION_NAME_PROPERTY:
		rygel_plugin_information_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

