/* rygel-description-file.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Parthiban Balasubramanian <P.Balasubramanian-contractor@cablelabs.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;
typedef struct _RygelDescriptionFilePrivate RygelDescriptionFilePrivate;
enum  {
	RYGEL_DESCRIPTION_FILE_0_PROPERTY,
	RYGEL_DESCRIPTION_FILE_NUM_PROPERTIES
};
static GParamSpec* rygel_description_file_properties[RYGEL_DESCRIPTION_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDescriptionFile {
	GObject parent_instance;
	RygelDescriptionFilePrivate * priv;
};

struct _RygelDescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelDescriptionFilePrivate {
	gchar** device_elements;
	gint device_elements_length1;
	gint _device_elements_size_;
	GUPnPXMLDoc* doc;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error) G_GNUC_DEPRECATED;
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

static gint RygelDescriptionFile_private_offset;
static gpointer rygel_description_file_parent_class = NULL;

GType rygel_description_file_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDescriptionFile, g_object_unref)
#define RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE "X_DLNADOC"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH "//*[local-name()=" " 'X_DLNADOC'" " and not(contains(.,\"DIAGE\"))" " and not(contains(.,\"LPE\"))]"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"DIAGE\")]"
#define RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP "+DIAGE+"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"LPE\")]"
#define RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP "+LPE+"
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file,
                                                  GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type,
                                                        const gchar* template_file,
                                                        GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type,
                                                                          GUPnPXMLDoc* doc);
void rygel_description_file_set_device_type (RygelDescriptionFile* self,
                                             const gchar* device_type);
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self,
                                                    const gchar* element,
                                                    const gchar* new_value,
                                                    const gchar* ns);
void rygel_description_file_set_model_description (RygelDescriptionFile* self,
                                                   const gchar* model_description);
void rygel_description_file_set_model_name (RygelDescriptionFile* self,
                                            const gchar* model_name);
void rygel_description_file_set_model_number (RygelDescriptionFile* self,
                                              const gchar* model_number);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self,
                                               const gchar* friendly_name);
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node,
                                      ...);
void rygel_description_file_set_udn (RygelDescriptionFile* self,
                                     const gchar* udn);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
void rygel_description_file_set_serial_number (RygelDescriptionFile* self,
                                               const gchar* serial);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self,
                                           RygelPluginCapabilities capabilities);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMetaConfig, g_object_unref)
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self,
                                               GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self,
                                                 GError** error);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self,
                                                  const gchar* dlnadoc_xpath,
                                                  const gchar* dlnadoc_non_xpath,
                                                  const gchar* dev_cap);
void rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self,
                                                     const gchar* dlnadoc_xpath);
static void _vala_array_add12 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self,
                                                   const gchar* element);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
static gboolean rygel_description_file_apply_xpath (RygelDescriptionFile* self,
                                             const gchar* xpath,
                                             xmlXPathObject** xpo);
static xmlNode* rygel_description_file_get_device_element (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_value_set_resource_info (GValue* value,
                                    gpointer v_object);
void rygel_value_take_resource_info (GValue* value,
                                     gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelResourceInfo, rygel_resource_info_unref)
void rygel_description_file_add_service (RygelDescriptionFile* self,
                                         const gchar* device_name,
                                         RygelResourceInfo* resource_info);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void rygel_value_set_icon_info (GValue* value,
                                gpointer v_object);
void rygel_value_take_icon_info (GValue* value,
                                 gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelIconInfo, rygel_icon_info_unref)
void rygel_description_file_add_icon (RygelDescriptionFile* self,
                                      const gchar* device_name,
                                      RygelIconInfo* icon_info,
                                      const gchar* url);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self,
                                                 const gchar* old_type,
                                                 const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self,
                                  const gchar* path,
                                  GError** error);
static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self,
                                                     const gchar* element);
static void rygel_description_file_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_description_file_get_instance_private (RygelDescriptionFile* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDescriptionFile_private_offset);
}

/**
     * Constructor to load a description file from disk
     *
     * @param template_file the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
RygelDescriptionFile*
rygel_description_file_construct (GType object_type,
                                  const gchar* template_file,
                                  GError** error)
{
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	GUPnPXMLDoc* _tmp1_;
	GUPnPXMLDoc* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (template_file != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp1_ = gupnp_xml_doc_new_from_path (template_file, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return self;
}

RygelDescriptionFile*
rygel_description_file_new (const gchar* template_file,
                            GError** error)
{
	return rygel_description_file_construct (RYGEL_TYPE_DESCRIPTION_FILE, template_file, error);
}

/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelDescriptionFile*
rygel_description_file_construct_from_xml_document (GType object_type,
                                                    GUPnPXMLDoc* doc)
{
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (doc);
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp0_;
	return self;
}

RygelDescriptionFile*
rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc)
{
	return rygel_description_file_construct_from_xml_document (RYGEL_TYPE_DESCRIPTION_FILE, doc);
}

/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void
rygel_description_file_set_device_type (RygelDescriptionFile* self,
                                        const gchar* device_type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_type != NULL);
	rygel_description_file_set_device_element (self, "deviceType", device_type, NULL);
}

/**
     * Modify the model description.
     *
     * A longer user friendly description of the device.
     *
     * @param model_description is the new model description.
     */
void
rygel_description_file_set_model_description (RygelDescriptionFile* self,
                                              const gchar* model_description)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_description != NULL);
	rygel_description_file_set_device_element (self, "modelDescription", model_description, NULL);
}

/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void
rygel_description_file_set_model_name (RygelDescriptionFile* self,
                                       const gchar* model_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_name != NULL);
	rygel_description_file_set_device_element (self, "modelName", model_name, NULL);
}

/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void
rygel_description_file_set_model_number (RygelDescriptionFile* self,
                                         const gchar* model_number)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_number != NULL);
	rygel_description_file_set_device_element (self, "modelNumber", model_number, NULL);
}

/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void
rygel_description_file_set_friendly_name (RygelDescriptionFile* self,
                                          const gchar* friendly_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (friendly_name != NULL);
	rygel_description_file_set_device_element (self, "friendlyName", friendly_name, NULL);
}

/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar*
rygel_description_file_get_friendly_name (RygelDescriptionFile* self)
{
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
	element = _tmp2_;
	_vala_assert (element != NULL, "element != null");
	_tmp3_ = (gchar*) xmlNodeGetContent (element);
	result = _tmp3_;
	return result;
}

/**
     * Set the Unique Device Name of the device.
     *
     * Unique Device Name is the UUID of this particular device instance.
     *
     * @param udn is the Unique Device Name of the device.
     */
void
rygel_description_file_set_udn (RygelDescriptionFile* self,
                                const gchar* udn)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (udn != NULL);
	rygel_description_file_set_device_element (self, "UDN", udn, NULL);
}

/**
     * Get the current UDN of the device.
     *
     * @return The currenly set UDN.
     */
gchar*
rygel_description_file_get_udn (RygelDescriptionFile* self)
{
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "UDN", NULL);
	element = _tmp2_;
	_tmp3_ = element;
	if (_tmp3_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp4_ = element;
	_tmp5_ = (gchar*) xmlNodeGetContent (_tmp4_);
	result = _tmp5_;
	return result;
}

/**
     * Set the Serial number of the device.
     *
     * @param serial is the Unique Device Name of the device.
     */
void
rygel_description_file_set_serial_number (RygelDescriptionFile* self,
                                          const gchar* serial)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (serial != NULL);
	rygel_description_file_set_device_element (self, "serialNumber", serial, NULL);
}

/**
     * Set the DLNA caps of this root device and while taking the
     * capabilities of the plugin into account.
     *
     * @param capabilities RygelPluginCapabilities flags
     */
static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len = len + _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len = len + (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

void
rygel_description_file_set_dlna_caps (RygelDescriptionFile* self,
                                      RygelPluginCapabilities capabilities)
{
	gchar** flags = NULL;
	gchar** _tmp0_;
	gint flags_length1;
	gint _flags_size_;
	gboolean _tmp19_ = FALSE;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp0_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	if ((RYGEL_PLUGIN_CAPABILITIES_UPLOAD & capabilities) != 0) {
		gboolean allow_upload = FALSE;
		gboolean allow_delete = FALSE;
		allow_upload = TRUE;
		allow_delete = FALSE;
		{
			RygelMetaConfig* config = NULL;
			RygelMetaConfig* _tmp1_;
			gboolean _tmp2_ = FALSE;
			RygelMetaConfig* _tmp3_;
			gboolean _tmp4_ = FALSE;
			RygelMetaConfig* _tmp5_;
			_tmp1_ = rygel_meta_config_get_default ();
			config = _tmp1_;
			_tmp3_ = config;
			_tmp2_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (config);
				goto __catch5_g_error;
			}
			allow_upload = _tmp2_;
			_tmp5_ = config;
			_tmp4_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (config);
				goto __catch5_g_error;
			}
			allow_delete = _tmp4_;
			_g_object_unref0 (config);
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (allow_upload) {
			gboolean can_upload = FALSE;
			gboolean _tmp12_ = FALSE;
			can_upload = FALSE;
			if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar* _tmp7_;
				_tmp6_ = flags;
				_tmp6__length1 = flags_length1;
				_tmp7_ = g_strdup ("image-upload");
				_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp7_);
				can_upload = TRUE;
			}
			if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar* _tmp9_;
				_tmp8_ = flags;
				_tmp8__length1 = flags_length1;
				_tmp9_ = g_strdup ("av-upload");
				_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp9_);
				can_upload = TRUE;
			}
			if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) {
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar* _tmp11_;
				_tmp10_ = flags;
				_tmp10__length1 = flags_length1;
				_tmp11_ = g_strdup ("audio-upload");
				_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp11_);
				can_upload = TRUE;
			}
			if (allow_delete) {
				_tmp12_ = can_upload;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* _tmp14_;
				_tmp13_ = flags;
				_tmp13__length1 = flags_length1;
				_tmp14_ = g_strdup ("create-item-with-OCM-destroy-item");
				_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp14_);
			}
		}
	}
	if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		_tmp15_ = flags;
		_tmp15__length1 = flags_length1;
		_tmp16_ = g_strdup ("content-synchronization");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp16_);
		_tmp17_ = flags;
		_tmp17__length1 = flags_length1;
		_tmp18_ = g_strdup ("create-child-container");
		_vala_array_add9 (&flags, &flags_length1, &_flags_size_, _tmp18_);
	}
	if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) == RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) {
		_tmp19_ = !((capabilities & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		_tmp20_ = flags;
		_tmp20__length1 = flags_length1;
		_tmp21_ = g_strdup ("create-child-container");
		_vala_array_add10 (&flags, &flags_length1, &_flags_size_, _tmp21_);
	}
	if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) == RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) {
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
		_tmp22_ = flags;
		_tmp22__length1 = flags_length1;
		_tmp23_ = g_strdup (RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
		_vala_array_add11 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
	} else {
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH);
	}
	if ((capabilities & RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) == RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		_tmp24_ = flags;
		_tmp24__length1 = flags_length1;
		_tmp25_ = g_strdup (RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
		_vala_array_add12 (&flags, &flags_length1, &_flags_size_, _tmp25_);
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
	} else {
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH);
	}
	_tmp26_ = flags;
	_tmp26__length1 = flags_length1;
	if (_tmp26__length1 > 0) {
		gchar* content = NULL;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = flags;
		_tmp27__length1 = flags_length1;
		_tmp28_ = _vala_g_strjoinv (",", _tmp27_, (gint) _tmp27__length1);
		content = _tmp28_;
		_tmp29_ = content;
		rygel_description_file_set_device_element (self, "X_DLNACAP", _tmp29_, "dlna");
		_g_free0 (content);
	} else {
		rygel_description_file_remove_device_element (self, "X_DLNACAP");
	}
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
}

void
rygel_description_file_clear_service_list (RygelDescriptionFile* self)
{
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "serviceList");
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self,
                                             const gchar* dlnadoc_xpath,
                                             const gchar* dlnadoc_non_xpath,
                                             const gchar* dev_cap)
{
	xmlXPathObject* dlna_doc_object = NULL;
	xmlXPathObject* tmp = NULL;
	xmlXPathObject* _tmp0_ = NULL;
	gboolean _tmp1_;
	xmlXPathObject* _tmp3_ = NULL;
	gboolean _tmp4_;
	xmlXPathObject* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlnadoc_xpath != NULL);
	g_return_if_fail (dlnadoc_non_xpath != NULL);
	g_return_if_fail (dev_cap != NULL);
	dlna_doc_object = NULL;
	_tmp1_ = rygel_description_file_apply_xpath (self, dlnadoc_xpath, &_tmp0_);
	tmp = _tmp0_;
	if (_tmp1_) {
		xmlXPathObject* _tmp2_;
		_tmp2_ = tmp;
		xmlXPathFreeObject (_tmp2_);
		return;
	}
	_tmp4_ = rygel_description_file_apply_xpath (self, dlnadoc_non_xpath, &_tmp3_);
	dlna_doc_object = _tmp3_;
	if (!_tmp4_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp7_;
				xmlNodeSet* _tmp8_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp9_;
				xmlNodeSet* _tmp10_;
				xmlNode* _tmp11_;
				gchar* node_content = NULL;
				xmlNode* _tmp12_;
				gchar* _tmp13_;
				gint doc_index = 0;
				const gchar* _tmp14_;
				gchar* devcap_content = NULL;
				xmlNode* device = NULL;
				xmlNode* _tmp15_;
				xmlNode* devcap_element = NULL;
				xmlNode* _tmp16_;
				xmlNode* _tmp17_;
				xmlNs* _tmp18_;
				xmlNode* _tmp19_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				xmlNode* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				xmlNode* _tmp38_;
				xmlNode* _tmp39_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = dlna_doc_object;
				_tmp8_ = _tmp7_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp8_))) {
					break;
				}
				_tmp9_ = dlna_doc_object;
				_tmp10_ = _tmp9_->nodesetval;
				_tmp11_ = xmlXPathNodeSetItem (_tmp10_, i);
				node = _tmp11_;
				_tmp12_ = node;
				_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
				node_content = _tmp13_;
				_tmp14_ = node_content;
				doc_index = string_last_index_of (_tmp14_, "/", 0);
				_tmp15_ = rygel_description_file_get_device_element (self);
				device = _tmp15_;
				_tmp16_ = device;
				_tmp17_ = node;
				_tmp18_ = _tmp17_->ns;
				_tmp19_ = xmlNewChild (_tmp16_, _tmp18_, (xmlChar*) RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE, (xmlChar*) NULL);
				devcap_element = _tmp19_;
				if (doc_index != -1) {
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_;
					_tmp20_ = node_content;
					_tmp21_ = node_content;
					_tmp22_ = strlen (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = string_slice (_tmp20_, (glong) (doc_index + 1), (glong) _tmp23_);
					_g_free0 (devcap_content);
					devcap_content = _tmp24_;
				} else {
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = node_content;
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (devcap_content);
					devcap_content = _tmp26_;
				}
				_tmp27_ = g_strconcat (dev_cap, "/", NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = devcap_content;
				_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				g_debug ("rygel-description-file.vala:348: %s", _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_tmp32_ = devcap_element;
				_tmp33_ = g_strconcat (dev_cap, "/", NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = devcap_content;
				_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
				_tmp37_ = _tmp36_;
				xmlNodeSetContent (_tmp32_, (xmlChar*) _tmp37_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp34_);
				_tmp38_ = node;
				_tmp39_ = devcap_element;
				xmlAddNextSibling (_tmp38_, _tmp39_);
				_g_free0 (devcap_content);
				_g_free0 (node_content);
			}
		}
	}
	_tmp40_ = dlna_doc_object;
	xmlXPathFreeObject (_tmp40_);
}

void
rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self,
                                                const gchar* dlnadoc_xpath)
{
	xmlXPathObject* devcap_object = NULL;
	xmlXPathObject* _tmp0_ = NULL;
	gboolean _tmp1_;
	xmlXPathObject* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlnadoc_xpath != NULL);
	devcap_object = NULL;
	_tmp1_ = rygel_description_file_apply_xpath (self, dlnadoc_xpath, &_tmp0_);
	devcap_object = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlXPathObject* _tmp4_;
				xmlNodeSet* _tmp5_;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp6_;
				xmlNodeSet* _tmp7_;
				xmlNode* _tmp8_;
				xmlNode* _tmp9_;
				xmlNode* _tmp10_;
				xmlNode* _tmp11_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = devcap_object;
				_tmp5_ = _tmp4_->nodesetval;
				if (!(i < xmlXPathNodeSetGetLength (_tmp5_))) {
					break;
				}
				_tmp6_ = devcap_object;
				_tmp7_ = _tmp6_->nodesetval;
				_tmp8_ = xmlXPathNodeSetItem (_tmp7_, i);
				node = _tmp8_;
				_tmp9_ = node;
				if (_tmp9_ == NULL) {
					continue;
				}
				_tmp10_ = node;
				xmlUnlinkNode (_tmp10_);
				_tmp11_ = node;
				xmlFreeNode (_tmp11_);
			}
		}
	}
	_tmp12_ = devcap_object;
	xmlXPathFreeObject (_tmp12_);
}

static xmlNode*
rygel_description_file_get_device_element (RygelDescriptionFile* self)
{
	xmlNode* result = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL);
	result = _tmp2_;
	return result;
}

static gboolean
rygel_description_file_apply_xpath (RygelDescriptionFile* self,
                                    const gchar* xpath,
                                    xmlXPathObject** xpo)
{
	xmlXPathObject* _vala_xpo = NULL;
	gboolean result = FALSE;
	xmlXPathContext* context = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlXPathContext* _tmp2_;
	xmlXPathObject* _result_ = NULL;
	xmlXPathContext* _tmp3_;
	xmlXPathObject* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	xmlXPathObject* _tmp7_;
	gboolean retval = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (xpath != NULL, FALSE);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = xmlXPathNewContext (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = xmlXPathEvalExpression ((xmlChar*) xpath, _tmp3_);
	_result_ = _tmp4_;
	_tmp7_ = _result_;
	if (_tmp7_ != NULL) {
		xmlXPathObject* _tmp8_;
		xmlXPathObjectType _tmp9_;
		_tmp8_ = _result_;
		_tmp9_ = _tmp8_->type;
		_tmp6_ = _tmp9_ == XPATH_NODESET;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		xmlXPathObject* _tmp10_;
		xmlNodeSet* _tmp11_;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->nodesetval;
		_tmp5_ = !xmlXPathNodeSetIsEmpty (_tmp11_);
	} else {
		_tmp5_ = FALSE;
	}
	retval = _tmp5_;
	if (!retval) {
		xmlXPathObject* _tmp13_;
		_tmp13_ = _result_;
		_tmp12_ = _tmp13_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		xmlXPathObject* _tmp14_;
		_vala_xpo = NULL;
		_tmp14_ = _result_;
		xmlXPathFreeObject (_tmp14_);
	} else {
		xmlXPathObject* _tmp15_;
		_tmp15_ = _result_;
		_vala_xpo = _tmp15_;
	}
	result = retval;
	_xmlXPathFreeContext0 (context);
	if (xpo) {
		*xpo = _vala_xpo;
	}
	return result;
}

void
rygel_description_file_add_service (RygelDescriptionFile* self,
                                    const gchar* device_name,
                                    RygelResourceInfo* resource_info)
{
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* service_node = NULL;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* url = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "serviceList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_;
		_tmp4_ = rygel_description_file_set_device_element (self, "serviceList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "service", (xmlChar*) NULL);
	service_node = _tmp6_;
	_tmp7_ = resource_info->upnp_type;
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceType", (xmlChar*) _tmp7_);
	_tmp8_ = resource_info->upnp_id;
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceId", (xmlChar*) _tmp8_);
	_tmp9_ = resource_info->description_path;
	_tmp10_ = g_strconcat ("/", _tmp9_, NULL);
	url = _tmp10_;
	_tmp11_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "SCPDURL", (xmlChar*) _tmp11_);
	_tmp12_ = g_strconcat ("/Control/", device_name, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "/", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_type_name (resource_info->type);
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_g_free0 (url);
	url = _tmp17_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp18_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "controlURL", (xmlChar*) _tmp18_);
	_tmp19_ = g_strconcat ("/Event/", device_name, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_type_name (resource_info->type);
	_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
	_g_free0 (url);
	url = _tmp24_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp25_ = url;
	xmlNewChild (service_node, NULL, (xmlChar*) "eventSubURL", (xmlChar*) _tmp25_);
	_g_free0 (url);
}

void
rygel_description_file_clear_icon_list (RygelDescriptionFile* self)
{
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "iconList");
}

void
rygel_description_file_add_icon (RygelDescriptionFile* self,
                                 const gchar* device_name,
                                 RygelIconInfo* icon_info,
                                 const gchar* url)
{
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* icon_node = NULL;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	gchar* width = NULL;
	gchar* _tmp7_;
	gchar* height = NULL;
	gchar* _tmp8_;
	gchar* depth = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "iconList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_;
		_tmp4_ = rygel_description_file_set_device_element (self, "iconList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "icon", (xmlChar*) NULL);
	icon_node = _tmp6_;
	_tmp7_ = g_strdup_printf ("%i", icon_info->width);
	width = _tmp7_;
	_tmp8_ = g_strdup_printf ("%i", icon_info->height);
	height = _tmp8_;
	_tmp9_ = g_strdup_printf ("%i", icon_info->depth);
	depth = _tmp9_;
	_tmp10_ = icon_info->mime_type;
	xmlNewChild (icon_node, NULL, (xmlChar*) "mimetype", (xmlChar*) _tmp10_);
	xmlNewChild (icon_node, NULL, (xmlChar*) "width", (xmlChar*) width);
	xmlNewChild (icon_node, NULL, (xmlChar*) "height", (xmlChar*) height);
	xmlNewChild (icon_node, NULL, (xmlChar*) "depth", (xmlChar*) depth);
	xmlNewChild (icon_node, NULL, (xmlChar*) "url", (xmlChar*) url);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}

/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void
rygel_description_file_modify_service_type (RygelDescriptionFile* self,
                                            const gchar* old_type,
                                            const gchar* new_type)
{
	xmlXPathObject* xpath_object = NULL;
	gchar* xpath = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	xmlXPathObject* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	xpath_object = NULL;
	_tmp0_ = g_strdup_printf (RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, old_type);
	xpath = _tmp0_;
	_tmp1_ = xpath;
	_tmp3_ = rygel_description_file_apply_xpath (self, _tmp1_, &_tmp2_);
	xpath_object = _tmp2_;
	if (_tmp3_) {
		xmlXPathObject* _tmp4_;
		xmlNodeSet* _tmp5_;
		xmlNode* _tmp6_;
		xmlXPathObject* _tmp7_;
		_tmp4_ = xpath_object;
		_tmp5_ = _tmp4_->nodesetval;
		_tmp6_ = xmlXPathNodeSetItem (_tmp5_, 0);
		xmlNodeSetContent (_tmp6_, (xmlChar*) new_type);
		_tmp7_ = xpath_object;
		xmlXPathFreeObject (_tmp7_);
	}
	_g_free0 (xpath);
}

/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
rygel_description_file_save (RygelDescriptionFile* self,
                             const gchar* path,
                             GError** error)
{
	gchar* mem = NULL;
	gint len = 0;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	mem = NULL;
	len = -1;
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	xmlDocDumpMemoryEnc (_tmp1_, (xmlChar**) (&_tmp2_), &_tmp3_, "UTF-8");
	_g_free0 (mem);
	mem = _tmp2_;
	len = _tmp3_;
	if (G_UNLIKELY (len <= 0)) {
		gchar* message = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp4_ = g_strdup (_ ("Failed to write modified description to %s"));
		message = _tmp4_;
		_tmp5_ = message;
		_tmp6_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp5_, path);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (message);
		_g_free0 (mem);
		return;
	}
	_tmp7_ = mem;
	_tmp8_ = string_replace (_tmp7_, "\n", "");
	_tmp9_ = _tmp8_;
	g_file_set_contents (path, _tmp9_, (gssize) -1, &_inner_error0_);
	_g_free0 (_tmp9_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (mem);
		return;
	}
	_g_free0 (mem);
}

static gint
rygel_description_file_index_of_device_element (RygelDescriptionFile* self,
                                                const gchar* element)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (element != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar** _tmp2_;
				gint _tmp2__length1;
				gchar** _tmp3_;
				gint _tmp3__length1;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->device_elements;
				_tmp2__length1 = self->priv->device_elements_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->device_elements;
				_tmp3__length1 = self->priv->device_elements_length1;
				_tmp4_ = _tmp3_[i];
				if (g_strcmp0 (_tmp4_, element) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

/**
     * Internal helper function to set an element to a new value,
     * creating it if needed.
     *
     * @param element below /root/device to be set.
     * @param new_value is the new content of that element.
     *
     * @returns the element that was modified (or created) or null
     */
static xmlNode*
rygel_description_file_set_device_element (RygelDescriptionFile* self,
                                           const gchar* element,
                                           const gchar* new_value,
                                           const gchar* ns)
{
	xmlNode* result = NULL;
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp6_;
	xmlDoc* _tmp7_;
	xmlNode* _tmp8_;
	xmlNs* xml_ns = NULL;
	xmlNode* _tmp13_;
	xmlNs* _tmp14_;
	xmlNode* _tmp15_;
	gint index = 0;
	xmlNode* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", element, NULL);
	xml_element = _tmp2_;
	_tmp3_ = xml_element;
	if (_tmp3_ != NULL) {
		xmlNode* _tmp4_;
		xmlNode* _tmp5_;
		_tmp4_ = xml_element;
		xmlNodeSetContent (_tmp4_, (xmlChar*) new_value);
		_tmp5_ = xml_element;
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->priv->doc;
	_tmp7_ = gupnp_xml_doc_get_doc (_tmp6_);
	_tmp8_ = rygel_xml_utils_get_element ((xmlNode*) _tmp7_, "root", "device", NULL);
	device_element = _tmp8_;
	xml_ns = NULL;
	if (ns != NULL) {
		GUPnPXMLDoc* _tmp9_;
		xmlDoc* _tmp10_;
		xmlNode* _tmp11_;
		xmlNs* _tmp12_;
		_tmp9_ = self->priv->doc;
		_tmp10_ = gupnp_xml_doc_get_doc (_tmp9_);
		_tmp11_ = device_element;
		_tmp12_ = xmlSearchNs (_tmp10_, _tmp11_, ns);
		xml_ns = _tmp12_;
	}
	_tmp13_ = device_element;
	_tmp14_ = xml_ns;
	_tmp15_ = xmlNewChild (_tmp13_, _tmp14_, (xmlChar*) element, (xmlChar*) new_value);
	xml_element = _tmp15_;
	index = rygel_description_file_index_of_device_element (self, element);
	if (index > -1) {
		xmlNode* sibling = NULL;
		xmlNode* _tmp28_;
		sibling = NULL;
		{
			gint _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = index;
			index = _tmp16_ - 1;
			_tmp17_ = TRUE;
			while (TRUE) {
				GUPnPXMLDoc* _tmp19_;
				xmlDoc* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				xmlNode* _tmp23_;
				xmlNode* _tmp24_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = index;
					index = _tmp18_ - 1;
				}
				_tmp17_ = FALSE;
				if (!(index > 0)) {
					break;
				}
				_tmp19_ = self->priv->doc;
				_tmp20_ = gupnp_xml_doc_get_doc (_tmp19_);
				_tmp21_ = self->priv->device_elements;
				_tmp21__length1 = self->priv->device_elements_length1;
				_tmp22_ = _tmp21_[index];
				_tmp23_ = rygel_xml_utils_get_element ((xmlNode*) _tmp20_, "root", "device", _tmp22_, NULL);
				sibling = _tmp23_;
				_tmp24_ = sibling;
				if (_tmp24_ != NULL) {
					xmlNode* _tmp25_;
					xmlNode* _tmp26_;
					xmlNode* _tmp27_;
					_tmp25_ = sibling;
					_tmp26_ = xml_element;
					_tmp27_ = xmlAddNextSibling (_tmp25_, _tmp26_);
					xml_element = _tmp27_;
					break;
				}
			}
		}
		_tmp28_ = sibling;
		if (_tmp28_ == NULL) {
			xmlNode* _tmp29_;
			xmlNode* _tmp30_;
			xmlNode* _tmp31_;
			_tmp29_ = device_element;
			_tmp30_ = xmlFirstElementChild (_tmp29_);
			sibling = _tmp30_;
			_tmp31_ = sibling;
			if (_tmp31_ != NULL) {
				xmlNode* _tmp32_;
				xmlNode* _tmp33_;
				xmlNode* _tmp34_;
				_tmp32_ = sibling;
				_tmp33_ = xml_element;
				_tmp34_ = xmlAddPrevSibling (_tmp32_, _tmp33_);
				xml_element = _tmp34_;
			}
		}
	}
	_tmp35_ = xml_element;
	result = _tmp35_;
	return result;
}

/**
     * Internal helper function to remove an element (if it exists).
     *
     * @param element below /root/device to be removed.
     */
static void
rygel_description_file_remove_device_element (RygelDescriptionFile* self,
                                              const gchar* element)
{
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = gupnp_xml_doc_get_doc (_tmp0_);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", element, NULL);
	xml_element = _tmp2_;
	_tmp3_ = xml_element;
	if (_tmp3_ != NULL) {
		xmlNode* _tmp4_;
		xmlNode* _tmp5_;
		_tmp4_ = xml_element;
		xmlUnlinkNode (_tmp4_);
		_tmp5_ = xml_element;
		xmlFreeNode (_tmp5_);
	}
}

static void
rygel_description_file_class_init (RygelDescriptionFileClass * klass,
                                   gpointer klass_data)
{
	rygel_description_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDescriptionFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_description_file_finalize;
}

static void
rygel_description_file_instance_init (RygelDescriptionFile * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	self->priv = rygel_description_file_get_instance_private (self);
	_tmp0_ = g_strdup ("deviceType");
	_tmp1_ = g_strdup ("friendlyName");
	_tmp2_ = g_strdup ("manufacturer");
	_tmp3_ = g_strdup ("manufacturerURL");
	_tmp4_ = g_strdup ("modelDescription");
	_tmp5_ = g_strdup ("modelName");
	_tmp6_ = g_strdup ("modelNumber");
	_tmp7_ = g_strdup ("modelURL");
	_tmp8_ = g_strdup ("serialNumber");
	_tmp9_ = g_strdup ("UDN");
	_tmp10_ = g_strdup ("UPC");
	_tmp11_ = g_strdup ("iconList");
	_tmp12_ = g_strdup ("serviceList");
	_tmp13_ = g_strdup ("deviceList");
	_tmp14_ = g_strdup ("presentationURL");
	_tmp15_ = g_new0 (gchar*, 15 + 1);
	_tmp15_[0] = _tmp0_;
	_tmp15_[1] = _tmp1_;
	_tmp15_[2] = _tmp2_;
	_tmp15_[3] = _tmp3_;
	_tmp15_[4] = _tmp4_;
	_tmp15_[5] = _tmp5_;
	_tmp15_[6] = _tmp6_;
	_tmp15_[7] = _tmp7_;
	_tmp15_[8] = _tmp8_;
	_tmp15_[9] = _tmp9_;
	_tmp15_[10] = _tmp10_;
	_tmp15_[11] = _tmp11_;
	_tmp15_[12] = _tmp12_;
	_tmp15_[13] = _tmp13_;
	_tmp15_[14] = _tmp14_;
	self->priv->device_elements = _tmp15_;
	self->priv->device_elements_length1 = 15;
	self->priv->_device_elements_size_ = self->priv->device_elements_length1;
}

static void
rygel_description_file_finalize (GObject * obj)
{
	RygelDescriptionFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile);
	self->priv->device_elements = (_vala_array_free (self->priv->device_elements, self->priv->device_elements_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->doc);
	G_OBJECT_CLASS (rygel_description_file_parent_class)->finalize (obj);
}

/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType
rygel_description_file_get_type (void)
{
	static volatile gsize rygel_description_file_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDescriptionFile), 0, (GInstanceInitFunc) rygel_description_file_instance_init, NULL };
		GType rygel_description_file_type_id;
		rygel_description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDescriptionFile", &g_define_type_info, 0);
		RygelDescriptionFile_private_offset = g_type_add_instance_private (rygel_description_file_type_id, sizeof (RygelDescriptionFilePrivate));
		g_once_init_leave (&rygel_description_file_type_id__volatile, rygel_description_file_type_id);
	}
	return rygel_description_file_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

