#[macro_use]
extern crate once_cell;

use std::collections::HashMap;
use once_cell::sync::{Lazy, OnceCell};

static HASHMAP: Lazy<HashMap<u32, &'static str>> = sync_lazy! {
    let mut m = HashMap::new();
    m.insert(0, "foo");
    m.insert(1, "bar");
    m.insert(2, "baz");
    m
};

// Same, but completely without macros
fn hashmap() -> &'static HashMap<u32, &'static str> {
    static INSTANCE: OnceCell<HashMap<u32, &'static str>> = OnceCell::INIT;
    INSTANCE.get_or_init(|| {
        let mut m = HashMap::new();
        m.insert(0, "foo");
        m.insert(1, "bar");
        m.insert(2, "baz");
        m
    })
}

fn main() {
    // First access to `HASHMAP` initializes it
    println!("The entry for `0` is \"{}\".", HASHMAP.get(&0).unwrap());

    // Any further access to `HASHMAP` just returns the computed value
    println!("The entry for `1` is \"{}\".", HASHMAP.get(&1).unwrap());

    // The same works for function-style:
    assert_eq!(hashmap().get(&0), Some(&"foo"));
    assert_eq!(hashmap().get(&0), Some(&"bar"));
}
