# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::StreamAnalytics
  module Models
    #
    # A streamng job object, containing all information associated with the
    # named streaming job.
    #
    class StreamingJob < MsRestAzure::Resource

      include MsRestAzure

      include MsRest::JSONable
      # @return [Sku] Describes the SKU of the streaming job. Required on PUT
      # (CreateOrReplace) requests.
      attr_accessor :sku

      # @return [String] A GUID uniquely identifying the streaming job. This
      # GUID is generated upon creation of the streaming job.
      attr_accessor :job_id

      # @return [String] Describes the provisioning status of the streaming
      # job.
      attr_accessor :provisioning_state

      # @return [String] Describes the state of the streaming job.
      attr_accessor :job_state

      # @return [OutputStartMode] This property should only be utilized when it
      # is desired that the job be started immediately upon creation. Value may
      # be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether
      # the starting point of the output event stream should start whenever the
      # job is started, start at a custom user time stamp specified via the
      # outputStartTime property, or start from the last event output time.
      # Possible values include: 'JobStartTime', 'CustomTime',
      # 'LastOutputEventTime'
      attr_accessor :output_start_mode

      # @return [DateTime] Value is either an ISO-8601 formatted time stamp
      # that indicates the starting point of the output event stream, or null
      # to indicate that the output event stream will start whenever the
      # streaming job is started. This property must have a value if
      # outputStartMode is set to CustomTime.
      attr_accessor :output_start_time

      # @return [DateTime] Value is either an ISO-8601 formatted timestamp
      # indicating the last output event time of the streaming job or null
      # indicating that output has not yet been produced. In case of multiple
      # outputs or multiple streams, this shows the latest value in that set.
      attr_accessor :last_output_event_time

      # @return [EventsOutOfOrderPolicy] Indicates the policy to apply to
      # events that arrive out of order in the input event stream. Possible
      # values include: 'Adjust', 'Drop'
      attr_accessor :events_out_of_order_policy

      # @return [OutputErrorPolicy] Indicates the policy to apply to events
      # that arrive at the output and cannot be written to the external storage
      # due to being malformed (missing column values, column values of wrong
      # type or size). Possible values include: 'Stop', 'Drop'
      attr_accessor :output_error_policy

      # @return [Integer] The maximum tolerable delay in seconds where
      # out-of-order events can be adjusted to be back in order.
      attr_accessor :events_out_of_order_max_delay_in_seconds

      # @return [Integer] The maximum tolerable delay in seconds where events
      # arriving late could be included.  Supported range is -1 to 1814399
      # (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the
      # property is absent, it is interpreted to have a value of -1.
      attr_accessor :events_late_arrival_max_delay_in_seconds

      # @return [String] The data locale of the stream analytics job. Value
      # should be the name of a supported .NET Culture from the set
      # https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx.
      # Defaults to 'en-US' if none specified.
      attr_accessor :data_locale

      # @return [CompatibilityLevel] Controls certain runtime behaviors of the
      # streaming job. Possible values include: '1.0'
      attr_accessor :compatibility_level

      # @return [DateTime] Value is an ISO-8601 formatted UTC timestamp
      # indicating when the streaming job was created.
      attr_accessor :created_date

      # @return [Array<Input>] A list of one or more inputs to the streaming
      # job. The name property for each input is required when specifying this
      # property in a PUT request. This property cannot be modify via a PATCH
      # operation. You must use the PATCH API available for the individual
      # input.
      attr_accessor :inputs

      # @return [Transformation] Indicates the query and the number of
      # streaming units to use for the streaming job. The name property of the
      # transformation is required when specifying this property in a PUT
      # request. This property cannot be modify via a PATCH operation. You must
      # use the PATCH API available for the individual tranformation.
      attr_accessor :transformation

      # @return [Array<Output>] A list of one or more outputs for the streaming
      # job. The name property for each output is required when specifying this
      # property in a PUT request. This property cannot be modify via a PATCH
      # operation. You must use the PATCH API available for the individual
      # output.
      attr_accessor :outputs

      # @return [Array<Function>] A list of one or more functions for the
      # streaming job. The name property for each function is required when
      # specifying this property in a PUT request. This property cannot be
      # modify via a PATCH operation. You must use the PATCH API available for
      # the individual transformation.
      attr_accessor :functions

      # @return [String] The current entity tag for the streaming job. This is
      # an opaque string. You can use it to detect whether the resource has
      # changed between requests. You can also use it in the If-Match or
      # If-None-Match headers for write operations for optimistic concurrency.
      attr_accessor :etag


      #
      # Mapper for StreamingJob class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'StreamingJob',
          type: {
            name: 'Composite',
            class_name: 'StreamingJob',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              sku: {
                required: false,
                serialized_name: 'properties.sku',
                type: {
                  name: 'Composite',
                  class_name: 'Sku'
                }
              },
              job_id: {
                required: false,
                read_only: true,
                serialized_name: 'properties.jobId',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              job_state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.jobState',
                type: {
                  name: 'String'
                }
              },
              output_start_mode: {
                required: false,
                serialized_name: 'properties.outputStartMode',
                type: {
                  name: 'String'
                }
              },
              output_start_time: {
                required: false,
                serialized_name: 'properties.outputStartTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_output_event_time: {
                required: false,
                read_only: true,
                serialized_name: 'properties.lastOutputEventTime',
                type: {
                  name: 'DateTime'
                }
              },
              events_out_of_order_policy: {
                required: false,
                serialized_name: 'properties.eventsOutOfOrderPolicy',
                type: {
                  name: 'String'
                }
              },
              output_error_policy: {
                required: false,
                serialized_name: 'properties.outputErrorPolicy',
                type: {
                  name: 'String'
                }
              },
              events_out_of_order_max_delay_in_seconds: {
                required: false,
                serialized_name: 'properties.eventsOutOfOrderMaxDelayInSeconds',
                type: {
                  name: 'Number'
                }
              },
              events_late_arrival_max_delay_in_seconds: {
                required: false,
                serialized_name: 'properties.eventsLateArrivalMaxDelayInSeconds',
                type: {
                  name: 'Number'
                }
              },
              data_locale: {
                required: false,
                serialized_name: 'properties.dataLocale',
                type: {
                  name: 'String'
                }
              },
              compatibility_level: {
                required: false,
                serialized_name: 'properties.compatibilityLevel',
                type: {
                  name: 'String'
                }
              },
              created_date: {
                required: false,
                read_only: true,
                serialized_name: 'properties.createdDate',
                type: {
                  name: 'DateTime'
                }
              },
              inputs: {
                required: false,
                serialized_name: 'properties.inputs',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'InputElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Input'
                      }
                  }
                }
              },
              transformation: {
                required: false,
                serialized_name: 'properties.transformation',
                type: {
                  name: 'Composite',
                  class_name: 'Transformation'
                }
              },
              outputs: {
                required: false,
                serialized_name: 'properties.outputs',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'OutputElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Output'
                      }
                  }
                }
              },
              functions: {
                required: false,
                serialized_name: 'properties.functions',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'FunctionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Function'
                      }
                  }
                }
              },
              etag: {
                required: false,
                read_only: true,
                serialized_name: 'properties.etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
