# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CognitiveServices
  #
  # Cognitive Services Management Client
  #
  class CheckSkuAvailability
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CheckSkuAvailability class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [CognitiveServicesManagementClient] reference to the CognitiveServicesManagementClient
    attr_reader :client

    #
    # Check available SKUs.
    #
    # @param skus [Array<SkuName>] The SKU of the resource.
    # @param kind [Kind] The Kind of the resource. Possible values include:
    # 'Academic', 'Bing.Autosuggest', 'Bing.Search', 'Bing.Speech',
    # 'Bing.SpellCheck', 'ComputerVision', 'ContentModerator', 'CustomSpeech',
    # 'Emotion', 'Face', 'LUIS', 'Recommendations', 'SpeakerRecognition', 'Speech',
    # 'SpeechTranslation', 'TextAnalytics', 'TextTranslation', 'WebLM'
    # @param type [String] The Type of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CheckSkuAvailabilityResultList] operation results.
    #
    def list(skus, kind, type, custom_headers = nil)
      response = list_async(skus, kind, type, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Check available SKUs.
    #
    # @param skus [Array<SkuName>] The SKU of the resource.
    # @param kind [Kind] The Kind of the resource. Possible values include:
    # 'Academic', 'Bing.Autosuggest', 'Bing.Search', 'Bing.Speech',
    # 'Bing.SpellCheck', 'ComputerVision', 'ContentModerator', 'CustomSpeech',
    # 'Emotion', 'Face', 'LUIS', 'Recommendations', 'SpeakerRecognition', 'Speech',
    # 'SpeechTranslation', 'TextAnalytics', 'TextTranslation', 'WebLM'
    # @param type [String] The Type of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(skus, kind, type, custom_headers = nil)
      list_async(skus, kind, type, custom_headers).value!
    end

    #
    # Check available SKUs.
    #
    # @param skus [Array<SkuName>] The SKU of the resource.
    # @param kind [Kind] The Kind of the resource. Possible values include:
    # 'Academic', 'Bing.Autosuggest', 'Bing.Search', 'Bing.Speech',
    # 'Bing.SpellCheck', 'ComputerVision', 'ContentModerator', 'CustomSpeech',
    # 'Emotion', 'Face', 'LUIS', 'Recommendations', 'SpeakerRecognition', 'Speech',
    # 'SpeechTranslation', 'TextAnalytics', 'TextTranslation', 'WebLM'
    # @param type [String] The Type of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(skus, kind, type, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.location is nil' if @client.location.nil?
      fail ArgumentError, 'skus is nil' if skus.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'type is nil' if type.nil?

      parameters = CheckSkuAvailabilityParameter.new
      unless skus.nil? && kind.nil? && type.nil?
        parameters.skus = skus
        parameters.kind = kind
        parameters.type = type
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CognitiveServices::Models::CheckSkuAvailabilityParameter.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.CognitiveServices/locations/{location}/checkSkuAvailability'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'location' => @client.location},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CognitiveServices::Models::CheckSkuAvailabilityResultList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
