# ifndef _RHEOLEF_EYE_H
# define _RHEOLEF_EYE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

# include "rheolef/vec.h"
# include "rheolef/solver.h"
namespace rheolef { 

/*Class:eye
NAME: @code{eye} - the identity matrix 
DESCRIPTION:       
  Following @code{octave}, the name @code{eye_rep} class is used in place of I to denote identity matrices
  because I is often used as a subscript or as sqrt(-1). The dimensions of @code{eye_rep} are
  determined by the context.
  This class is here useful in the context of preconditioner interfaces: it allows
  calls of algorithms without any preconditioners, e.g.
  @example
    int status = cg (a, x, b, eye_rep<Float>(), 100, 1e-7);
  @end example
AUTHOR: 
    Pierre Saramito
    Pierre.Saramito@imag.fr
    LMC-IMAG, 38041 Grenoble cedex 9, France
DATE: 
    28 january 1997
End:
*/
//<eye:
template<class T, class M = rheo_default_memory_model>
class eye_rep : public solver_abstract_rep<T,M> {
public:
  eye_rep (const solver_option& opt = solver_option());
  void update_values (const csr<T,M>&) {}
  vec<T,M> operator*   (const vec<T,M>& x) const { return x; }
  vec<T,M> solve       (const vec<T,M>& x) const { return x; }
  vec<T,M> trans_solve (const vec<T,M>& x) const { return x; }
};
//>eye:

template<class T, class M>
inline
eye_rep<T,M>::eye_rep (const solver_option& opt)
 : solver_abstract_rep<T,M>(opt)
{
}

}// namespace rheolef
# endif // _RHEOLEF_EYE_H
