///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*Prog:makefish
NAME: @code{makefish} -- make a Poisson matrix 
@pindex makefish
@pindex hb
@cindex finite difference
@cindex Dirichlet problem
@cindex Poisson matrix
@clindex asr
@clindex csr
@toindex @code{ghostview}
SYNOPSIS: 
    @example
	makefish @var{bloc-size}
    @end example
DESCRIPTION:       
    Demonstration of @code{asr} and @code{csr} usage.
    Print Poisson matrix in Harwell-Boeing format on standard output.
    The Poisson matrix is the finite-diference of the bidimensional
    Laplace operator with Dirichlet boundary conditions
    on a square region.
EXAMPLE:
    enter command as:
    @example
    	makefish 10 | hb -ps | ghostview -
    @end example
SEE ALSO:
    "hb"(1), class "csr", class "asr"
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE: 
    20 february 1997
METHOD: @makefish
End:
*/
//<makefish:
# include "rheolef/skit.h"
#ifndef USE_NOT_MAIN
using namespace rheolef;
#endif // USE_NOT_MAIN
using namespace std;
csr<Float> makefish (unsigned int bloc_size)
{
  unsigned int size = bloc_size*bloc_size;
  asr<Float> a(size,size);
  for (unsigned int i = 0; i < size; i++)
    a.entry(i, i) = 4;
  for (unsigned int ib = 0; ib < bloc_size; ib++)
    for (unsigned int i=ib*bloc_size; i<(ib+1)*bloc_size-1; i++)
      a.entry(i, i+1) = a.entry(i+1, i) = -1; 
  for (unsigned int i = 0; i < (bloc_size-1)*bloc_size; i++)
    a.entry(i,i+bloc_size) = a.entry(i+bloc_size, i) = -1;
  return csr<Float>(a);
}
#ifndef USE_NOT_MAIN
int main(int argc, char *argv[])
{
  if (argc < 2 || atoi(argv[1]) < 1)
    cerr << argv[0] << ": usage: " 
	 << argv[0] << " <bloc size>" << endl;
  else {
    cout << makefish (atoi(argv[1]));
  }
  return 0;
}
#endif // USE_NOT_MAIN
//>makefish:
