% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncount.R
\name{uncount}
\alias{uncount}
\title{"Uncount" a data frame}
\usage{
uncount(data, weights, .remove = TRUE, .id = NULL)
}
\arguments{
\item{data}{A data frame, tibble, or grouped tibble.}

\item{weights}{A vector of weights. Evaluated in the context of \code{data};
supports quasiquotation.}

\item{.remove}{If \code{TRUE}, and \code{weights} is a \code{single}}

\item{.id}{Supply a string to create a new variable which gives a unique
identifier for each created row.}
}
\description{
Performs the opposite operation to \code{\link[dplyr:count]{dplyr::count()}}, duplicating rows
according to a weighting variable (or expression).
}
\examples{
df <- tibble(x = c("a", "b"), n = c(1, 2))
uncount(df, n)
uncount(df, n, .id = "id")

# You can also use constants
uncount(df, 2)

# Or expressions
uncount(df, 2 / n)
}
