% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periods.r
\name{period}
\alias{is.period}
\alias{period}
\title{Create a period object.}
\usage{
period(num = NULL, units = "second", ...)

is.period(x)
}
\arguments{
\item{num}{a numeric vector that lists the number of time units to be
included in the period. From v1.6.0 \code{num} can also be a character
vector that specifies durations in a convenient shorthand format. All
unambiguous name units and abbreviations are supported. One letter "m"
stands for months, "M" stands for minutes. See examples.}

\item{units}{a character vector that lists the type of units to be used. The
units in units are matched to the values in num according to their
order. When \code{num} is character, this argument is ignored.}

\item{...}{a list of time units to be included in the period and their
amounts. Seconds, minutes,  hours, days, weeks, months, and years are
supported. Normally only one of \code{num} or \code{...} are present. If
both are present, the periods are concatenated.}

\item{x}{an R object}
}
\value{
a period object
}
\description{
\code{period} creates a period object with the specified values. period
provides the behaviour of \code{\link{period}} in a way that is more
suitable for automating within a function.
}
\details{
Within a Period object, time units do not have a fixed length (except for
seconds) until they are added to a date-time. The length of each time unit
will depend on the date-time to which it is added. For example, a year that
begins on 2009-01-01 will be 365 days long.  A year that begins on 2012-01-01
will be 366 days long. When math is performed with a period object, each unit
is applied separately. How the length of a period is distributed among its
units is non-trivial. For example, when leap seconds occur 1 minute is longer
than 60 seconds.

Periods track the change in the "clock time" between two date-times. They
are measured in common time related units: years, months, days, hours,
minutes, and seconds. Each unit except for seconds must be expressed in
integer values.

Period objects can be easily created with the helper functions
\code{\link{years}}, \code{\link{months}}, \code{\link{weeks}},
\code{\link{days}}, \code{\link{hours}}, \code{\link{minutes}},
and \code{\link{seconds}}. These objects can be added to and subtracted
to date-times to create a user interface similar to object oriented programming.

Note: Arithmetic with periods can results in undefined behavior when
non-existent dates are involved (such as February 29th). Please see
\code{\link{Period-class}} for more details and \code{\link{\%m+\%}} and
\code{\link{add_with_rollback}} for alternative operations.
}
\examples{
period(c(90, 5), c("second", "minute"))
#  "5M 90S"
period(-1, "days")
period(c(3, 1, 2, 13, 1), c("second", "minute", "hour", "day", "week"))
period(c(1, -60), c("hour", "minute"))
period(0, "second")
period (second = 90, minute = 5)
period(day = -1)
period(second = 3, minute = 1, hour = 2, day = 13, week = 1)
period(hour = 1, minute = -60)
period(second = 0)
period(c(1, -60), c("hour", "minute"), hour = c(1, 2), minute = c(3, 4))
period("2M 1sec")
period("2hours 2minutes 1second")
period("2d 2H 2M 2S")
period("2days 2hours 2mins 2secs")
# Missing numerals default to 1. Repeated units are added up.
duration("day day")
# Comparison with characters is supported from v1.6.0.
duration("day 2 sec") > "day 1sec"
is.period(as.Date("2009-08-03")) # FALSE
is.period(period(months= 1, days = 15)) # TRUE
}
\seealso{
\code{\link{Period-class}}, \code{\link{quick_periods}},
  \code{\link{\%m+\%}}, \code{\link{add_with_rollback}}
}
\keyword{chron}
\keyword{classes}

