% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/embedding.R
\name{sample_sphere_volume}
\alias{sample_sphere_volume}
\title{Sample vectors uniformly from the volume of a sphere}
\usage{
sample_sphere_volume(dim, n = 1, radius = 1, positive = TRUE)
}
\arguments{
\item{dim}{Integer scalar, the dimension of the random vectors.}

\item{n}{Integer scalar, the sample size.}

\item{radius}{Numeric scalar, the radius of the sphere to sample.}

\item{positive}{Logical scalar, whether to sample from the positive orthant
of the sphere.}
}
\value{
A \code{dim} (length of the \code{alpha} vector for
\code{sample_dirichlet}) times \code{n} matrix, whose columns are the sample
vectors.
}
\description{
Sample finite-dimensional vectors to use as latent position vectors in
random dot product graphs
}
\details{
\code{sample_sphere_volume} generates uniform samples from \eqn{S^{dim-1}}
(the \code{(dim-1)}-sphere) i.e. the Euclidean norm of the samples is
smaller or equal to \code{radius}.
}
\examples{
lpvs.sph.vol <- sample_sphere_volume(dim=10, n=20, radius=1)
RDP.graph.4  <- sample_dot_product(lpvs.sph.vol)
vec.norm     <- apply(lpvs.sph.vol, 2, function(x) { sum(x^2) })
vec.norm
}
\seealso{
Other latent position vector samplers: \code{\link{sample_dirichlet}};
  \code{\link{sample_sphere_surface}}
}

