% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make.R
\name{make_star}
\alias{graph.star}
\alias{make_star}
\alias{star}
\title{Create a star graph, a tree with n vertices and n - 1 leaves}
\usage{
make_star(n, mode = c("in", "out", "mutual", "undirected"), center = 1)

star(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{mode}{It defines the direction of the
edges, \code{in}: the edges point \emph{to} the center, \code{out}:
the edges point \emph{from} the center, \code{mutual}: a directed
star is created with mutual edges, \code{undirected}: the edges
are undirected.}

\item{center}{ID of the center vertex.}

\item{...}{Passed to \code{make_star}.}
}
\value{
An igraph graph.
}
\description{
\code{star} creates a star graph, in this every single vertex is
connected to the center vertex and nobody else.
}
\examples{
make_star(10, mode = "out")
make_star(5, mode = "undirected")
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{chordal_ring}},
  \code{\link{graph.extended.chordal.ring}},
  \code{\link{make_chordal_ring}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_edgelist}},
  \code{\link{graph.edgelist}},
  \code{\link{graph_from_edgelist}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_citation_graph}},
  \code{\link{graph.full.citation}},
  \code{\link{make_full_citation_graph}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.ring}},
  \code{\link{make_ring}}, \code{\link{ring}};
  \code{\link{graph.tree}}, \code{\link{make_tree}},
  \code{\link{tree}}
}
\concept{
Star graph
}

