% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_ordination}
\alias{plot_ordination}
\title{General ordination plotter based on ggplot2.}
\usage{
plot_ordination(physeq, ordination, type = "samples", axes = 1:2,
  color = NULL, shape = NULL, label = NULL, title = NULL,
  justDF = FALSE)
}
\arguments{
\item{physeq}{(Required). \code{\link{phyloseq-class}}. 
The data about which you want to 
plot and annotate the ordination.}

\item{ordination}{(Required). An ordination object. Many different classes
of ordination are defined by \code{R} packages. Ordination classes
currently supported/created by the \code{\link{ordinate}} function are
supported here. There is no default, as the expectation is that the 
ordination will be performed and saved prior to calling this plot function.}

\item{type}{(Optional). The plot type. Default is \code{"samples"}. The
currently supported options are 
\code{c("samples", "sites", "species", "taxa", "biplot", "split", "scree")}.
The option
``taxa'' is equivalent to ``species'' in this case, and similarly,
``samples'' is equivalent to ``sites''. 
The options
\code{"sites"} and \code{"species"} result in a single-plot of just the 
sites/samples or species/taxa of the ordination, respectively.
The \code{"biplot"} and \code{"split"} options result in a combined
plot with both taxa and samples, either combined into one plot (``biplot'')
or 
separated in two facet panels (``split''), respectively.
The \code{"scree"} option results in a call to \code{\link{plot_scree}},
which produces an ordered bar plot of the normalized eigenvalues
associated with each ordination axis.}

\item{axes}{(Optional). A 2-element vector indicating the axes of the 
ordination that should be used for plotting. 
Can be \code{\link{character-class}} or \code{\link{integer-class}},
naming the index name or index of the desired axis for the horizontal 
and vertical axes, respectively, in that order. The default value, 
\code{c(1, 2)}, specifies the first two axes of the provided ordination.}

\item{color}{(Optional). Default \code{NULL}. Character string.
 The name of the variable to map to
 colors in the plot. 
 This can be a sample variable 
 (among the set returned by \code{sample_variables(physeq)} )
 or
 taxonomic rank
 (among the set returned by \code{rank_names(physeq)}).

 Note that the color scheme is chosen automatically
 by \code{link{ggplot}},
 but it can be modified afterward with an additional layer using
 \code{\link[ggplot2]{scale_color_manual}}.}

\item{shape}{(Optional). Default \code{NULL}. Character string.
 The name of the variable to map
 to different shapes on the plot. 
 Similar to \code{color} option, but for the shape if points.

 The shape scale is chosen automatically by \code{link{ggplot}},
 but it can be modified afterward with an additional layer using
 \code{\link[ggplot2]{scale_shape_manual}}.}

\item{label}{(Optional). Default \code{NULL}. Character string.
The name of the variable to map to text labels on the plot.
Similar to \code{color} option, but for plotting text.}

\item{title}{(Optional). Default \code{NULL}. Character string.
The main title for the graphic.}

\item{justDF}{(Optional). Default \code{FALSE}. Logical.
Instead of returning a ggplot2-object, do you just want the relevant
\code{data.frame} that was used to build the plot? This is a 
user-accessible option for obtaining the \code{data.frame}, in 
in principal to make a custom plot that isn't possible with the
available options in this function. For contributing new functions
(developers), the  
\code{\link{phyloseq-package}} provides/uses an internal function
to build the key features of the \code{data.frame} prior to plot-build.}
}
\value{
A \code{\link{ggplot}} plot object, graphically summarizing
 the ordination result for the specified axes.
}
\description{
There are many useful examples of phyloseq ordination graphics in the
\href{http://joey711.github.io/phyloseq/plot_ordination-examples}{phyloseq online tutorials}.
Convenience wrapper for plotting ordination results as a 
\code{ggplot2}-graphic, including
additional annotation in the form of shading, shape, and/or labels of
sample variables.
}
\examples{
# See other examples at
# http://joey711.github.io/phyloseq/plot_ordination-examples
data(GlobalPatterns)
GP = prune_taxa(names(sort(taxa_sums(GlobalPatterns), TRUE)[1:50]), GlobalPatterns)
gp_bray_pcoa = ordinate(GP, "CCA", "bray")
plot_ordination(GP, gp_bray_pcoa, "samples", color="SampleType")
}
\seealso{
Many more examples are included in the 
 \href{http://joey711.github.io/phyloseq/plot_ordination-examples}{phyloseq online tutorials}.

Also see the general wrapping function:

\code{\link{plot_phyloseq}}
}

