% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doEStep.R
\name{doEStep}
\alias{doEStep}
\title{Compute the Expectation step.}
\usage{
doEStep(countResiduals, zeroResiduals, zeroIndices)
}
\arguments{
\item{countResiduals}{Residuals from the count model.}

\item{zeroResiduals}{Residuals from the zero model.}

\item{zeroIndices}{Index (matrix m x n) of counts that are zero/non-zero.}
}
\value{
Updated matrix (m x n) of estimate responsibilities (probabilities
that a count comes from a spike distribution at 0).
}
\description{
Estimates the responsibilities $z_ij = fracpi_j cdot I_0(y_ijpi_j cdot
I_0(y_ij + (1-pi_j) cdot f_count(y_ij
}
\details{
Maximum-likelihood estimates are approximated using the EM algorithm where
we treat mixture membership $delta_ij$ = 1 if $y_ij$ is generated from the
zero point mass as latent indicator variables. The density is defined as
$f_zig(y_ij = pi_j(S_j) cdot f_0(y_ij) +(1-pi_j (S_j))cdot
f_count(y_ij;mu_i,sigma_i^2)$. The log-likelihood in this extended model is
$(1-delta_ij) log f_count(y;mu_i,sigma_i^2 )+delta_ij log
pi_j(s_j)+(1-delta_ij)log (1-pi_j (sj))$. The responsibilities are defined
as $z_ij = pr(delta_ij=1 | data)$.
}
\seealso{
\code{\link{fitZig}}
}

