// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been auto-generated by code_generator_v8.py. DO NOT MODIFY!

#include "bindings/core/v8/V8PerformanceObserverCallback.h"

#include "bindings/core/v8/ScriptController.h"
#include "bindings/core/v8/V8Binding.h"
#include "bindings/core/v8/V8PerformanceObserver.h"
#include "bindings/core/v8/V8PerformanceObserverEntryList.h"
#include "core/dom/ExecutionContext.h"
#include "wtf/Assertions.h"

namespace blink {

V8PerformanceObserverCallback::V8PerformanceObserverCallback(v8::Local<v8::Function> callback, v8::Local<v8::Object> owner, ScriptState* scriptState)
    : ActiveDOMCallback(scriptState->executionContext())
    , m_callback(scriptState->isolate(), callback)
    , m_scriptState(scriptState)
{
    V8HiddenValue::setHiddenValue(scriptState, owner, V8HiddenValue::callback(scriptState->isolate()), callback);
    m_callback.setWeak(this, &setWeakCallback);
}

V8PerformanceObserverCallback::~V8PerformanceObserverCallback()
{
}

void V8PerformanceObserverCallback::handleEvent(PerformanceObserverEntryList* entries, PerformanceObserver* observer)
{
    if (!canInvokeCallback())
        return;

    if (!m_scriptState->contextIsValid())
        return;
    ScriptState::Scope scope(m_scriptState.get());

    if (m_callback.isEmpty())
        return;
    v8::Local<v8::Value> observerHandle = toV8(observer, m_scriptState->context()->Global(), m_scriptState->isolate());
    if (observerHandle.IsEmpty()) {
        if (!isScriptControllerTerminating())
            CRASH();
        return;
    }

    if (!observerHandle->IsObject())
        return;

    v8::Local<v8::Object> thisObject = v8::Local<v8::Object>::Cast(observerHandle);
    v8::Local<v8::Value> entriesHandle = toV8(entries, m_scriptState->context()->Global(), m_scriptState->isolate());
    if (entriesHandle.IsEmpty()) {
        return;
    }
    v8::Local<v8::Value> argv[] = { entriesHandle, observerHandle };

    v8::TryCatch exceptionCatcher(m_scriptState->isolate());
    exceptionCatcher.SetVerbose(true);
    ScriptController::callFunction(m_scriptState->executionContext(), m_callback.newLocal(m_scriptState->isolate()), thisObject, 2, argv, m_scriptState->isolate());
}

void V8PerformanceObserverCallback::setWeakCallback(const v8::WeakCallbackInfo<V8PerformanceObserverCallback>& data)
{
    data.GetParameter()->m_callback.clear();
}

DEFINE_TRACE(V8PerformanceObserverCallback)
{
    PerformanceObserverCallback::trace(visitor);
    ActiveDOMCallback::trace(visitor);
}

} // namespace blink
