// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * third_party/sketchology/proto/rect_bounds.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('sketchology.proto.Rect');
goog.provide('sketchology.proto.RectBounds');

goog.require('goog.proto2.Message');



/**
 * Message Rect.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.Rect = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.Rect, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.Rect.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.Rect} The cloned message.
 * @override
 */
sketchology.proto.Rect.prototype.clone;


/**
 * Gets the value of the xlow field.
 * @return {?number} The value.
 */
sketchology.proto.Rect.prototype.getXlow = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the xlow field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Rect.prototype.getXlowOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the xlow field.
 * @param {number} value The value.
 */
sketchology.proto.Rect.prototype.setXlow = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the xlow field has a value.
 */
sketchology.proto.Rect.prototype.hasXlow = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the xlow field.
 */
sketchology.proto.Rect.prototype.xlowCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the xlow field.
 */
sketchology.proto.Rect.prototype.clearXlow = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the xhigh field.
 * @return {?number} The value.
 */
sketchology.proto.Rect.prototype.getXhigh = function() {
  return /** @type {?number} */ (this.get$Value(2));
};


/**
 * Gets the value of the xhigh field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Rect.prototype.getXhighOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the xhigh field.
 * @param {number} value The value.
 */
sketchology.proto.Rect.prototype.setXhigh = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the xhigh field has a value.
 */
sketchology.proto.Rect.prototype.hasXhigh = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the xhigh field.
 */
sketchology.proto.Rect.prototype.xhighCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the xhigh field.
 */
sketchology.proto.Rect.prototype.clearXhigh = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the ylow field.
 * @return {?number} The value.
 */
sketchology.proto.Rect.prototype.getYlow = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the ylow field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Rect.prototype.getYlowOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the ylow field.
 * @param {number} value The value.
 */
sketchology.proto.Rect.prototype.setYlow = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the ylow field has a value.
 */
sketchology.proto.Rect.prototype.hasYlow = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the ylow field.
 */
sketchology.proto.Rect.prototype.ylowCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the ylow field.
 */
sketchology.proto.Rect.prototype.clearYlow = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the yhigh field.
 * @return {?number} The value.
 */
sketchology.proto.Rect.prototype.getYhigh = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the yhigh field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.Rect.prototype.getYhighOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the yhigh field.
 * @param {number} value The value.
 */
sketchology.proto.Rect.prototype.setYhigh = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the yhigh field has a value.
 */
sketchology.proto.Rect.prototype.hasYhigh = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the yhigh field.
 */
sketchology.proto.Rect.prototype.yhighCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the yhigh field.
 */
sketchology.proto.Rect.prototype.clearYhigh = function() {
  this.clear$Field(4);
};



/**
 * Message RectBounds.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.RectBounds = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.RectBounds, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.RectBounds.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.RectBounds} The cloned message.
 * @override
 */
sketchology.proto.RectBounds.prototype.clone;


/**
 * Gets the value of the mbr field.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.RectBounds.prototype.getMbr = function() {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(1));
};


/**
 * Gets the value of the mbr field or the default value if not set.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.RectBounds.prototype.getMbrOrDefault = function() {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the mbr field.
 * @param {!sketchology.proto.Rect} value The value.
 */
sketchology.proto.RectBounds.prototype.setMbr = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the mbr field has a value.
 */
sketchology.proto.RectBounds.prototype.hasMbr = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the mbr field.
 */
sketchology.proto.RectBounds.prototype.mbrCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the mbr field.
 */
sketchology.proto.RectBounds.prototype.clearMbr = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the fit_rects field at the index given.
 * @param {number} index The index to lookup.
 * @return {?sketchology.proto.Rect} The value.
 */
sketchology.proto.RectBounds.prototype.getFitRects = function(index) {
  return /** @type {?sketchology.proto.Rect} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the fit_rects field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!sketchology.proto.Rect} The value.
 */
sketchology.proto.RectBounds.prototype.getFitRectsOrDefault = function(index) {
  return /** @type {!sketchology.proto.Rect} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the fit_rects field.
 * @param {!sketchology.proto.Rect} value The value to add.
 */
sketchology.proto.RectBounds.prototype.addFitRects = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the fit_rects field.
 * @return {!Array<!sketchology.proto.Rect>} The values in the field.
 */
sketchology.proto.RectBounds.prototype.fitRectsArray = function() {
  return /** @type {!Array<!sketchology.proto.Rect>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the fit_rects field has a value.
 */
sketchology.proto.RectBounds.prototype.hasFitRects = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the fit_rects field.
 */
sketchology.proto.RectBounds.prototype.fitRectsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the fit_rects field.
 */
sketchology.proto.RectBounds.prototype.clearFitRects = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the max_dim field.
 * @return {?number} The value.
 */
sketchology.proto.RectBounds.prototype.getMaxDim = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the max_dim field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.RectBounds.prototype.getMaxDimOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the max_dim field.
 * @param {number} value The value.
 */
sketchology.proto.RectBounds.prototype.setMaxDim = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the max_dim field has a value.
 */
sketchology.proto.RectBounds.prototype.hasMaxDim = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the max_dim field.
 */
sketchology.proto.RectBounds.prototype.maxDimCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the max_dim field.
 */
sketchology.proto.RectBounds.prototype.clearMaxDim = function() {
  this.clear$Field(3);
};


/** @override */
sketchology.proto.Rect.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.Rect.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'Rect',
        fullName: 'sketchology.proto.Rect'
      },
      1: {
        name: 'xlow',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      2: {
        name: 'xhigh',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      3: {
        name: 'ylow',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      4: {
        name: 'yhigh',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.Rect.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.Rect, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.Rect.getDescriptor =
    sketchology.proto.Rect.prototype.getDescriptor;


/** @override */
sketchology.proto.RectBounds.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.RectBounds.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'RectBounds',
        fullName: 'sketchology.proto.RectBounds'
      },
      1: {
        name: 'mbr',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      2: {
        name: 'fit_rects',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.Rect
      },
      3: {
        name: 'max_dim',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.RectBounds.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.RectBounds, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.RectBounds.getDescriptor =
    sketchology.proto.RectBounds.prototype.getDescriptor;
