// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2018 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_ext_autogen.cpp:
//   Defines the GLES extension entry points.

#include "libGLESv2/entry_points_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/validationES.h"
#include "libGLESv2/global_state.h"

#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"

namespace gl
{

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY BlitFramebufferANGLE(GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlitFramebufferANGLE>(srcX0, srcY0, srcX1, srcY1, dstX0,
                                                                dstY0, dstX1, dstY1, mask, filter);

        if (context->skipValidation() ||
            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                                         dstY1, mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY RenderbufferStorageMultisampleANGLE(GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::RenderbufferStorageMultisampleANGLE>(
            target, samples, internalformat, width, height);

        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisampleANGLE(context, target, samples, internalformat,
                                                        width, height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY DrawArraysInstancedANGLE(GLenum mode,
                                          GLint first,
                                          GLsizei count,
                                          GLsizei primcount)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d, GLsizei primcount = %d)",
          mode, first, count, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawArraysInstancedANGLE>(mode, first, count, primcount);

        if (context->skipValidation() ||
            ValidateDrawArraysInstancedANGLE(context, mode, first, count, primcount))
        {
            context->drawArraysInstanced(mode, first, count, primcount);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedANGLE(GLenum mode,
                                            GLsizei count,
                                            GLenum type,
                                            const void *indices,
                                            GLsizei primcount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%0.8p, GLsizei primcount = %d)",
        mode, count, type, indices, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawElementsInstancedANGLE>(mode, count, type, indices,
                                                                      primcount);

        if (context->skipValidation() ||
            ValidateDrawElementsInstancedANGLE(context, mode, count, type, indices, primcount))
        {
            context->drawElementsInstanced(mode, count, type, indices, primcount);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttribDivisorANGLE>(index, divisor);

        if (context->skipValidation() || ValidateVertexAttribDivisorANGLE(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

// GL_ANGLE_translated_shader_source
void GL_APIENTRY GetTranslatedShaderSourceANGLE(GLuint shader,
                                                GLsizei bufsize,
                                                GLsizei *length,
                                                GLchar *source)
{
    EVENT(
        "(GLuint shader = %u, GLsizei bufsize = %d, GLsizei *length = 0x%0.8p, GLchar *source = "
        "0x%0.8p)",
        shader, bufsize, length, source);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTranslatedShaderSourceANGLE>(shader, bufsize, length,
                                                                          source);

        if (context->skipValidation() ||
            ValidateGetTranslatedShaderSourceANGLE(context, shader, bufsize, length, source))
        {
            context->getTranslatedShaderSource(shader, bufsize, length, source);
        }
    }
}

// GL_EXT_debug_marker
void GL_APIENTRY InsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%0.8p)", length, marker);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::InsertEventMarkerEXT>(length, marker);

        if (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker))
        {
            context->insertEventMarker(length, marker);
        }
    }
}

void GL_APIENTRY PopGroupMarkerEXT()
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PopGroupMarkerEXT>();

        if (context->skipValidation() || ValidatePopGroupMarkerEXT(context))
        {
            context->popGroupMarker();
        }
    }
}

void GL_APIENTRY PushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%0.8p)", length, marker);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PushGroupMarkerEXT>(length, marker);

        if (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker))
        {
            context->pushGroupMarker(length, marker);
        }
    }
}

// GL_EXT_discard_framebuffer
void GL_APIENTRY DiscardFramebufferEXT(GLenum target,
                                       GLsizei numAttachments,
                                       const GLenum *attachments)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = 0x%0.8p)",
        target, numAttachments, attachments);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DiscardFramebufferEXT>(target, numAttachments,
                                                                 attachments);

        if (context->skipValidation() ||
            ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments))
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
    }
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY BeginQueryEXT(GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BeginQueryEXT>(target, id);

        if (context->skipValidation() || ValidateBeginQueryEXT(context, target, id))
        {
            context->beginQuery(target, id);
        }
    }
}

void GL_APIENTRY DeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%0.8p)", n, ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteQueriesEXT>(n, ids);

        if (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY EndQueryEXT(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::EndQueryEXT>(target);

        if (context->skipValidation() || ValidateEndQueryEXT(context, target))
        {
            context->endQuery(target);
        }
    }
}

void GL_APIENTRY GenQueriesEXT(GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%0.8p)", n, ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenQueriesEXT>(n, ids);

        if (context->skipValidation() || ValidateGenQueriesEXT(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint64 *params = 0x%0.8p)", id, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetQueryObjecti64vEXT>(id, pname, params);

        if (context->skipValidation() || ValidateGetQueryObjecti64vEXT(context, id, pname, params))
        {
            context->getQueryObjecti64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", id, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetQueryObjectivEXT>(id, pname, params);

        if (context->skipValidation() || ValidateGetQueryObjectivEXT(context, id, pname, params))
        {
            context->getQueryObjectiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint64 *params = 0x%0.8p)", id, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetQueryObjectui64vEXT>(id, pname, params);

        if (context->skipValidation() || ValidateGetQueryObjectui64vEXT(context, id, pname, params))
        {
            context->getQueryObjectui64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%0.8p)", id, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetQueryObjectuivEXT>(id, pname, params);

        if (context->skipValidation() || ValidateGetQueryObjectuivEXT(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetQueryivEXT>(target, pname, params);

        if (context->skipValidation() || ValidateGetQueryivEXT(context, target, pname, params))
        {
            context->getQueryiv(target, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsQueryEXT(GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsQueryEXT>(id);

        if (context->skipValidation() || ValidateIsQueryEXT(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
}

void GL_APIENTRY QueryCounterEXT(GLuint id, GLenum target)
{
    EVENT("(GLuint id = %u, GLenum target = 0x%X)", id, target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::QueryCounterEXT>(id, target);

        if (context->skipValidation() || ValidateQueryCounterEXT(context, id, target))
        {
            context->queryCounter(id, target);
        }
    }
}

// GL_EXT_draw_buffers
void GL_APIENTRY DrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%0.8p)", n, bufs);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawBuffersEXT>(n, bufs);

        if (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

// GL_EXT_map_buffer_range
void GL_APIENTRY FlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %d, GLsizeiptr length = %d)", target, offset,
          length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::FlushMappedBufferRangeEXT>(targetPacked, offset, length);

        if (context->skipValidation() ||
            ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void *GL_APIENTRY MapBufferRangeEXT(GLenum target,
                                    GLintptr offset,
                                    GLsizeiptr length,
                                    GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %d, GLsizeiptr length = %d, GLbitfield access = "
        "0x%X)",
        target, offset, length, access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::MapBufferRangeEXT>(targetPacked, offset, length, access);

        if (context->skipValidation() ||
            ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
}

// GL_EXT_occlusion_query_boolean
// BeginQueryEXT is already defined.

// DeleteQueriesEXT is already defined.

// EndQueryEXT is already defined.

// GenQueriesEXT is already defined.

// GetQueryObjectuivEXT is already defined.

// GetQueryivEXT is already defined.

// IsQueryEXT is already defined.

// GL_EXT_robustness
GLenum GL_APIENTRY GetGraphicsResetStatusEXT()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetGraphicsResetStatusEXT>();

        if (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context))
        {
            return context->getGraphicsResetStatus();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
}

void GL_APIENTRY GetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat *params = "
        "0x%0.8p)",
        program, location, bufSize, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetnUniformfvEXT>(program, location, bufSize, params);

        if (context->skipValidation() ||
            ValidateGetnUniformfvEXT(context, program, location, bufSize, params))
        {
            context->getnUniformfv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint *params = 0x%0.8p)",
        program, location, bufSize, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetnUniformivEXT>(program, location, bufSize, params);

        if (context->skipValidation() ||
            ValidateGetnUniformivEXT(context, program, location, bufSize, params))
        {
            context->getnUniformiv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY ReadnPixelsEXT(GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *data)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, void *data = 0x%0.8p)",
        x, y, width, height, format, type, bufSize, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ReadnPixelsEXT>(x, y, width, height, format, type,
                                                          bufSize, data);

        if (context->skipValidation() ||
            ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
    }
}

// GL_EXT_texture_storage
void GL_APIENTRY TexStorage1DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d)",
        target, levels, internalformat, width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexStorage1DEXT>(target, levels, internalformat, width);

        if (context->skipValidation() ||
            ValidateTexStorage1DEXT(context, target, levels, internalformat, width))
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
    }
}

void GL_APIENTRY
TexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d)",
        target, levels, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexStorage2DEXT>(target, levels, internalformat, width,
                                                           height);

        if (context->skipValidation() ||
            ValidateTexStorage2DEXT(context, target, levels, internalformat, width, height))
        {
            context->texStorage2D(target, levels, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexStorage3DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d)",
        target, levels, internalformat, width, height, depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexStorage3DEXT>(target, levels, internalformat, width,
                                                           height, depth);

        if (context->skipValidation() ||
            ValidateTexStorage3DEXT(context, target, levels, internalformat, width, height, depth))
        {
            context->texStorage3D(target, levels, internalformat, width, height, depth);
        }
    }
}

// GL_KHR_debug
void GL_APIENTRY DebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    EVENT("(GLDEBUGPROCKHR callback = 0x%0.8p, const void *userParam = 0x%0.8p)", callback,
          userParam);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DebugMessageCallbackKHR>(callback, userParam);

        if (context->skipValidation() ||
            ValidateDebugMessageCallbackKHR(context, callback, userParam))
        {
            context->debugMessageCallback(callback, userParam);
        }
    }
}

void GL_APIENTRY DebugMessageControlKHR(GLenum source,
                                        GLenum type,
                                        GLenum severity,
                                        GLsizei count,
                                        const GLuint *ids,
                                        GLboolean enabled)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLenum severity = 0x%X, GLsizei count = %d, "
        "const GLuint *ids = 0x%0.8p, GLboolean enabled = %u)",
        source, type, severity, count, ids, enabled);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DebugMessageControlKHR>(source, type, severity, count,
                                                                  ids, enabled);

        if (context->skipValidation() ||
            ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled))
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
    }
}

void GL_APIENTRY DebugMessageInsertKHR(GLenum source,
                                       GLenum type,
                                       GLuint id,
                                       GLenum severity,
                                       GLsizei length,
                                       const GLchar *buf)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLuint id = %u, GLenum severity = 0x%X, "
        "GLsizei length = %d, const GLchar *buf = 0x%0.8p)",
        source, type, id, severity, length, buf);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DebugMessageInsertKHR>(source, type, id, severity, length,
                                                                 buf);

        if (context->skipValidation() ||
            ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf))
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
    }
}

GLuint GL_APIENTRY GetDebugMessageLogKHR(GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog)
{
    EVENT(
        "(GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%0.8p, GLenum *types = "
        "0x%0.8p, GLuint *ids = 0x%0.8p, GLenum *severities = 0x%0.8p, GLsizei *lengths = 0x%0.8p, "
        "GLchar *messageLog = 0x%0.8p)",
        count, bufSize, sources, types, ids, severities, lengths, messageLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetDebugMessageLogKHR>(
            count, bufSize, sources, types, ids, severities, lengths, messageLog);

        if (context->skipValidation() ||
            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types, ids, severities,
                                          lengths, messageLog))
        {
            return context->getDebugMessageLog(count, bufSize, sources, types, ids, severities,
                                               lengths, messageLog);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
}

void GL_APIENTRY
GetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%0.8p, GLchar *label = 0x%0.8p)",
        identifier, name, bufSize, length, label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetObjectLabelKHR>(identifier, name, bufSize, length,
                                                             label);

        if (context->skipValidation() ||
            ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label))
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetObjectPtrLabelKHR(const void *ptr,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    EVENT(
        "(const void *ptr = 0x%0.8p, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLchar "
        "*label = 0x%0.8p)",
        ptr, bufSize, length, label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetObjectPtrLabelKHR>(ptr, bufSize, length, label);

        if (context->skipValidation() ||
            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label))
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetPointervKHR(GLenum pname, void **params)
{
    EVENT("(GLenum pname = 0x%X, void **params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetPointervKHR>(pname, params);

        if (context->skipValidation() || ValidateGetPointervKHR(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

void GL_APIENTRY ObjectLabelKHR(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei length = %d, const GLchar *label = "
        "0x%0.8p)",
        identifier, name, length, label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ObjectLabelKHR>(identifier, name, length, label);

        if (context->skipValidation() ||
            ValidateObjectLabelKHR(context, identifier, name, length, label))
        {
            context->objectLabel(identifier, name, length, label);
        }
    }
}

void GL_APIENTRY ObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    EVENT("(const void *ptr = 0x%0.8p, GLsizei length = %d, const GLchar *label = 0x%0.8p)", ptr,
          length, label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ObjectPtrLabelKHR>(ptr, length, label);

        if (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label))
        {
            context->objectPtrLabel(ptr, length, label);
        }
    }
}

void GL_APIENTRY PopDebugGroupKHR()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PopDebugGroupKHR>();

        if (context->skipValidation() || ValidatePopDebugGroupKHR(context))
        {
            context->popDebugGroup();
        }
    }
}

void GL_APIENTRY PushDebugGroupKHR(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    EVENT(
        "(GLenum source = 0x%X, GLuint id = %u, GLsizei length = %d, const GLchar *message = "
        "0x%0.8p)",
        source, id, length, message);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PushDebugGroupKHR>(source, id, length, message);

        if (context->skipValidation() ||
            ValidatePushDebugGroupKHR(context, source, id, length, message))
        {
            context->pushDebugGroup(source, id, length, message);
        }
    }
}

// GL_NV_fence
void GL_APIENTRY DeleteFencesNV(GLsizei n, const GLuint *fences)
{
    EVENT("(GLsizei n = %d, const GLuint *fences = 0x%0.8p)", n, fences);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteFencesNV>(n, fences);

        if (context->skipValidation() || ValidateDeleteFencesNV(context, n, fences))
        {
            context->deleteFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY FinishFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::FinishFenceNV>(fence);

        if (context->skipValidation() || ValidateFinishFenceNV(context, fence))
        {
            context->finishFenceNV(fence);
        }
    }
}

void GL_APIENTRY GenFencesNV(GLsizei n, GLuint *fences)
{
    EVENT("(GLsizei n = %d, GLuint *fences = 0x%0.8p)", n, fences);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenFencesNV>(n, fences);

        if (context->skipValidation() || ValidateGenFencesNV(context, n, fences))
        {
            context->genFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY GetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    EVENT("(GLuint fence = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", fence, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetFenceivNV>(fence, pname, params);

        if (context->skipValidation() || ValidateGetFenceivNV(context, fence, pname, params))
        {
            context->getFenceivNV(fence, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsFenceNV>(fence);

        if (context->skipValidation() || ValidateIsFenceNV(context, fence))
        {
            return context->isFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
}

void GL_APIENTRY SetFenceNV(GLuint fence, GLenum condition)
{
    EVENT("(GLuint fence = %u, GLenum condition = 0x%X)", fence, condition);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::SetFenceNV>(fence, condition);

        if (context->skipValidation() || ValidateSetFenceNV(context, fence, condition))
        {
            context->setFenceNV(fence, condition);
        }
    }
}

GLboolean GL_APIENTRY TestFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TestFenceNV>(fence);

        if (context->skipValidation() || ValidateTestFenceNV(context, fence))
        {
            return context->testFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
}

// GL_OES_EGL_image
void GL_APIENTRY EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%0.8p)", target, image);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::EGLImageTargetRenderbufferStorageOES>(target, image);

        if (context->skipValidation() ||
            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image))
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
    }
}

void GL_APIENTRY EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%0.8p)", target, image);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::EGLImageTargetTexture2DOES>(target, image);

        if (context->skipValidation() || ValidateEGLImageTargetTexture2DOES(context, target, image))
        {
            context->eGLImageTargetTexture2D(target, image);
        }
    }
}

// GL_OES_draw_texture
void GL_APIENTRY DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    EVENT(
        "(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat width = %f, GLfloat height = %f)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexfOES>(x, y, z, width, height);

        if (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height))
        {
            context->drawTexf(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexfvOES(const GLfloat *coords)
{
    EVENT("(const GLfloat *coords = 0x%0.8p)", coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexfvOES>(coords);

        if (context->skipValidation() || ValidateDrawTexfvOES(context, coords))
        {
            context->drawTexfv(coords);
        }
    }
}

void GL_APIENTRY DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height = %d)", x, y,
          z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexiOES>(x, y, z, width, height);

        if (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height))
        {
            context->drawTexi(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexivOES(const GLint *coords)
{
    EVENT("(const GLint *coords = 0x%0.8p)", coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexivOES>(coords);

        if (context->skipValidation() || ValidateDrawTexivOES(context, coords))
        {
            context->drawTexiv(coords);
        }
    }
}

void GL_APIENTRY DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    EVENT(
        "(GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort width = %d, GLshort height = %d)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexsOES>(x, y, z, width, height);

        if (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height))
        {
            context->drawTexs(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexsvOES(const GLshort *coords)
{
    EVENT("(const GLshort *coords = 0x%0.8p)", coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexsvOES>(coords);

        if (context->skipValidation() || ValidateDrawTexsvOES(context, coords))
        {
            context->drawTexsv(coords);
        }
    }
}

void GL_APIENTRY DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    EVENT(
        "(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X, GLfixed width = 0x%X, GLfixed "
        "height = 0x%X)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexxOES>(x, y, z, width, height);

        if (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height))
        {
            context->drawTexx(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexxvOES(const GLfixed *coords)
{
    EVENT("(const GLfixed *coords = 0x%0.8p)", coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawTexxvOES>(coords);

        if (context->skipValidation() || ValidateDrawTexxvOES(context, coords))
        {
            context->drawTexxv(coords);
        }
    }
}

// GL_OES_get_program_binary
void GL_APIENTRY GetProgramBinaryOES(GLuint program,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLenum *binaryFormat,
                                     void *binary)
{
    EVENT(
        "(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLenum "
        "*binaryFormat = 0x%0.8p, void *binary = 0x%0.8p)",
        program, bufSize, length, binaryFormat, binary);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramBinaryOES>(program, bufSize, length,
                                                               binaryFormat, binary);

        if (context->skipValidation() ||
            ValidateGetProgramBinaryOES(context, program, bufSize, length, binaryFormat, binary))
        {
            context->getProgramBinary(program, bufSize, length, binaryFormat, binary);
        }
    }
}

void GL_APIENTRY ProgramBinaryOES(GLuint program,
                                  GLenum binaryFormat,
                                  const void *binary,
                                  GLint length)
{
    EVENT(
        "(GLuint program = %u, GLenum binaryFormat = 0x%X, const void *binary = 0x%0.8p, GLint "
        "length = %d)",
        program, binaryFormat, binary, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramBinaryOES>(program, binaryFormat, binary, length);

        if (context->skipValidation() ||
            ValidateProgramBinaryOES(context, program, binaryFormat, binary, length))
        {
            context->programBinary(program, binaryFormat, binary, length);
        }
    }
}

// GL_OES_mapbuffer
void GL_APIENTRY GetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::GetBufferPointervOES>(targetPacked, pname, params);

        if (context->skipValidation() ||
            ValidateGetBufferPointervOES(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

void *GL_APIENTRY MapBufferOES(GLenum target, GLenum access)
{
    EVENT("(GLenum target = 0x%X, GLenum access = 0x%X)", target, access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::MapBufferOES>(targetPacked, access);

        if (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access))
        {
            return context->mapBuffer(targetPacked, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
}

GLboolean GL_APIENTRY UnmapBufferOES(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::UnmapBufferOES>(targetPacked);

        if (context->skipValidation() || ValidateUnmapBufferOES(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBufferOES, GLboolean>();
}

// GL_OES_matrix_palette
void GL_APIENTRY CurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    EVENT("(GLuint matrixpaletteindex = %u)", matrixpaletteindex);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CurrentPaletteMatrixOES>(matrixpaletteindex);

        if (context->skipValidation() ||
            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex))
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
    }
}

void GL_APIENTRY LoadPaletteFromModelViewMatrixOES()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LoadPaletteFromModelViewMatrixOES>();

        if (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context))
        {
            context->loadPaletteFromModelViewMatrix();
        }
    }
}

void GL_APIENTRY MatrixIndexPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        size, type, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MatrixIndexPointerOES>(size, type, stride, pointer);

        if (context->skipValidation() ||
            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer))
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY WeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        size, type, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::WeightPointerOES>(size, type, stride, pointer);

        if (context->skipValidation() ||
            ValidateWeightPointerOES(context, size, type, stride, pointer))
        {
            context->weightPointer(size, type, stride, pointer);
        }
    }
}

// GL_OES_point_size_array
void GL_APIENTRY PointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)", type, stride,
          pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointSizePointerOES>(type, stride, pointer);

        if (context->skipValidation() ||
            ValidatePointSizePointerOES(context, type, stride, pointer))
        {
            context->pointSizePointer(type, stride, pointer);
        }
    }
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY QueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    EVENT("(GLfixed *mantissa = 0x%0.8p, GLint *exponent = 0x%0.8p)", mantissa, exponent);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::QueryMatrixxOES>(mantissa, exponent);

        if (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent))
        {
            return context->queryMatrixx(mantissa, exponent);
        }
    }

    return GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
}

// GL_OES_vertex_array_object
void GL_APIENTRY BindVertexArrayOES(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindVertexArrayOES>(array);

        if (context->skipValidation() || ValidateBindVertexArrayOES(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY DeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%0.8p)", n, arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteVertexArraysOES>(n, arrays);

        if (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%0.8p)", n, arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenVertexArraysOES>(n, arrays);

        if (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

GLboolean GL_APIENTRY IsVertexArrayOES(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsVertexArrayOES>(array);

        if (context->skipValidation() || ValidateIsVertexArrayOES(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
}
}  // namespace gl
