// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2018 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_2_0_autogen.cpp:
//   Defines the GLES 2.0 entry points.

#include "libGLESv2/entry_points_gles_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/validationES2.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY AttachShader(GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::AttachShader>(program, shader);

        if (context->skipValidation() || ValidateAttachShader(context, program, shader))
        {
            context->attachShader(program, shader);
        }
    }
}

void GL_APIENTRY BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%0.8p)", program, index,
          name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindAttribLocation>(program, index, name);

        if (context->skipValidation() || ValidateBindAttribLocation(context, program, index, name))
        {
            context->bindAttribLocation(program, index, name);
        }
    }
}

void GL_APIENTRY BindFramebuffer(GLenum target, GLuint framebuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindFramebuffer>(target, framebuffer);

        if (context->skipValidation() || ValidateBindFramebuffer(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindRenderbuffer>(target, renderbuffer);

        if (context->skipValidation() || ValidateBindRenderbuffer(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

void GL_APIENTRY BlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlendColor>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateBlendColor(context, red, green, blue, alpha))
        {
            context->blendColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY BlendEquation(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlendEquation>(mode);

        if (context->skipValidation() || ValidateBlendEquation(context, mode))
        {
            context->blendEquation(mode);
        }
    }
}

void GL_APIENTRY BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    EVENT("(GLenum modeRGB = 0x%X, GLenum modeAlpha = 0x%X)", modeRGB, modeAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlendEquationSeparate>(modeRGB, modeAlpha);

        if (context->skipValidation() || ValidateBlendEquationSeparate(context, modeRGB, modeAlpha))
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
    }
}

void GL_APIENTRY BlendFuncSeparate(GLenum sfactorRGB,
                                   GLenum dfactorRGB,
                                   GLenum sfactorAlpha,
                                   GLenum dfactorAlpha)
{
    EVENT(
        "(GLenum sfactorRGB = 0x%X, GLenum dfactorRGB = 0x%X, GLenum sfactorAlpha = 0x%X, GLenum "
        "dfactorAlpha = 0x%X)",
        sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlendFuncSeparate>(sfactorRGB, dfactorRGB, sfactorAlpha,
                                                             dfactorAlpha);

        if (context->skipValidation() ||
            ValidateBlendFuncSeparate(context, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha))
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
    }
}

GLenum GL_APIENTRY CheckFramebufferStatus(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CheckFramebufferStatus>(target);

        if (context->skipValidation() || ValidateCheckFramebufferStatus(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
}

void GL_APIENTRY CompileShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CompileShader>(shader);

        if (context->skipValidation() || ValidateCompileShader(context, shader))
        {
            context->compileShader(shader);
        }
    }
}

GLuint GL_APIENTRY CreateProgram()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CreateProgram>();

        if (context->skipValidation() || ValidateCreateProgram(context))
        {
            return context->createProgram();
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
}

GLuint GL_APIENTRY CreateShader(GLenum type)
{
    EVENT("(GLenum type = 0x%X)", type);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CreateShader>(type);

        if (context->skipValidation() || ValidateCreateShader(context, type))
        {
            return context->createShader(type);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
}

void GL_APIENTRY DeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%0.8p)", n, framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteFramebuffers>(n, framebuffers);

        if (context->skipValidation() || ValidateDeleteFramebuffers(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteProgram>(program);

        if (context->skipValidation() || ValidateDeleteProgram(context, program))
        {
            context->deleteProgram(program);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%0.8p)", n, renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteRenderbuffers>(n, renderbuffers);

        if (context->skipValidation() || ValidateDeleteRenderbuffers(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY DeleteShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteShader>(shader);

        if (context->skipValidation() || ValidateDeleteShader(context, shader))
        {
            context->deleteShader(shader);
        }
    }
}

void GL_APIENTRY DetachShader(GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DetachShader>(program, shader);

        if (context->skipValidation() || ValidateDetachShader(context, program, shader))
        {
            context->detachShader(program, shader);
        }
    }
}

void GL_APIENTRY DisableVertexAttribArray(GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DisableVertexAttribArray>(index);

        if (context->skipValidation() || ValidateDisableVertexAttribArray(context, index))
        {
            context->disableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY EnableVertexAttribArray(GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::EnableVertexAttribArray>(index);

        if (context->skipValidation() || ValidateEnableVertexAttribArray(context, index))
        {
            context->enableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY FramebufferRenderbuffer(GLenum target,
                                         GLenum attachment,
                                         GLenum renderbuffertarget,
                                         GLuint renderbuffer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::FramebufferRenderbuffer>(
            target, attachment, renderbuffertarget, renderbuffer);

        if (context->skipValidation() ||
            ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                            renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferTexture2D(GLenum target,
                                      GLenum attachment,
                                      GLenum textarget,
                                      GLuint texture,
                                      GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::FramebufferTexture2D>(target, attachment, textarget,
                                                                texture, level);

        if (context->skipValidation() ||
            ValidateFramebufferTexture2D(context, target, attachment, textarget, texture, level))
        {
            context->framebufferTexture2D(target, attachment, textarget, texture, level);
        }
    }
}

void GL_APIENTRY GenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%0.8p)", n, framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenFramebuffers>(n, framebuffers);

        if (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%0.8p)", n, renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenRenderbuffers>(n, renderbuffers);

        if (context->skipValidation() || ValidateGenRenderbuffers(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenerateMipmap(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenerateMipmap>(target);

        if (context->skipValidation() || ValidateGenerateMipmap(context, target))
        {
            context->generateMipmap(target);
        }
    }
}

void GL_APIENTRY GetActiveAttrib(GLuint program,
                                 GLuint index,
                                 GLsizei bufSize,
                                 GLsizei *length,
                                 GLint *size,
                                 GLenum *type,
                                 GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, "
        "GLint *size = 0x%0.8p, GLenum *type = 0x%0.8p, GLchar *name = 0x%0.8p)",
        program, index, bufSize, length, size, type, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetActiveAttrib>(program, index, bufSize, length, size,
                                                           type, name);

        if (context->skipValidation() ||
            ValidateGetActiveAttrib(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveAttrib(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetActiveUniform(GLuint program,
                                  GLuint index,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLint *size,
                                  GLenum *type,
                                  GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, "
        "GLint *size = 0x%0.8p, GLenum *type = 0x%0.8p, GLchar *name = 0x%0.8p)",
        program, index, bufSize, length, size, type, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetActiveUniform>(program, index, bufSize, length, size,
                                                            type, name);

        if (context->skipValidation() ||
            ValidateGetActiveUniform(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveUniform(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetAttachedShaders(GLuint program,
                                    GLsizei maxCount,
                                    GLsizei *count,
                                    GLuint *shaders)
{
    EVENT(
        "(GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%0.8p, GLuint *shaders = "
        "0x%0.8p)",
        program, maxCount, count, shaders);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetAttachedShaders>(program, maxCount, count, shaders);

        if (context->skipValidation() ||
            ValidateGetAttachedShaders(context, program, maxCount, count, shaders))
        {
            context->getAttachedShaders(program, maxCount, count, shaders);
        }
    }
}

GLint GL_APIENTRY GetAttribLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%0.8p)", program, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetAttribLocation>(program, name);

        if (context->skipValidation() || ValidateGetAttribLocation(context, program, name))
        {
            return context->getAttribLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
}

void GL_APIENTRY GetFramebufferAttachmentParameteriv(GLenum target,
                                                     GLenum attachment,
                                                     GLenum pname,
                                                     GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%0.8p)",
        target, attachment, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetFramebufferAttachmentParameteriv>(target, attachment,
                                                                               pname, params);

        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameteriv(context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetProgramInfoLog(GLuint program,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *infoLog)
{
    EVENT(
        "(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLchar *infoLog = "
        "0x%0.8p)",
        program, bufSize, length, infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramInfoLog>(program, bufSize, length, infoLog);

        if (context->skipValidation() ||
            ValidateGetProgramInfoLog(context, program, bufSize, length, infoLog))
        {
            context->getProgramInfoLog(program, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", program, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramiv>(program, pname, params);

        if (context->skipValidation() || ValidateGetProgramiv(context, program, pname, params))
        {
            context->getProgramiv(program, pname, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetRenderbufferParameteriv>(target, pname, params);

        if (context->skipValidation() ||
            ValidateGetRenderbufferParameteriv(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    EVENT(
        "(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLchar *infoLog = "
        "0x%0.8p)",
        shader, bufSize, length, infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetShaderInfoLog>(shader, bufSize, length, infoLog);

        if (context->skipValidation() ||
            ValidateGetShaderInfoLog(context, shader, bufSize, length, infoLog))
        {
            context->getShaderInfoLog(shader, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetShaderPrecisionFormat(GLenum shadertype,
                                          GLenum precisiontype,
                                          GLint *range,
                                          GLint *precision)
{
    EVENT(
        "(GLenum shadertype = 0x%X, GLenum precisiontype = 0x%X, GLint *range = 0x%0.8p, GLint "
        "*precision = 0x%0.8p)",
        shadertype, precisiontype, range, precision);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetShaderPrecisionFormat>(shadertype, precisiontype,
                                                                    range, precision);

        if (context->skipValidation() ||
            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype, range, precision))
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
    }
}

void GL_APIENTRY GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    EVENT(
        "(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLchar *source = "
        "0x%0.8p)",
        shader, bufSize, length, source);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetShaderSource>(shader, bufSize, length, source);

        if (context->skipValidation() ||
            ValidateGetShaderSource(context, shader, bufSize, length, source))
        {
            context->getShaderSource(shader, bufSize, length, source);
        }
    }
}

void GL_APIENTRY GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    EVENT("(GLuint shader = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", shader, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetShaderiv>(shader, pname, params);

        if (context->skipValidation() || ValidateGetShaderiv(context, shader, pname, params))
        {
            context->getShaderiv(shader, pname, params);
        }
    }
}

GLint GL_APIENTRY GetUniformLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%0.8p)", program, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetUniformLocation>(program, name);

        if (context->skipValidation() || ValidateGetUniformLocation(context, program, name))
        {
            return context->getUniformLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
}

void GL_APIENTRY GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat *params = 0x%0.8p)", program,
          location, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetUniformfv>(program, location, params);

        if (context->skipValidation() || ValidateGetUniformfv(context, program, location, params))
        {
            context->getUniformfv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUniformiv(GLuint program, GLint location, GLint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint *params = 0x%0.8p)", program, location,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetUniformiv>(program, location, params);

        if (context->skipValidation() || ValidateGetUniformiv(context, program, location, params))
        {
            context->getUniformiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, void **pointer = 0x%0.8p)", index, pname,
          pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetVertexAttribPointerv>(index, pname, pointer);

        if (context->skipValidation() ||
            ValidateGetVertexAttribPointerv(context, index, pname, pointer))
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
    }
}

void GL_APIENTRY GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)", index, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetVertexAttribfv>(index, pname, params);

        if (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params))
        {
            context->getVertexAttribfv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", index, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetVertexAttribiv>(index, pname, params);

        if (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params))
        {
            context->getVertexAttribiv(index, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsFramebuffer(GLuint framebuffer)
{
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsFramebuffer>(framebuffer);

        if (context->skipValidation() || ValidateIsFramebuffer(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsProgram>(program);

        if (context->skipValidation() || ValidateIsProgram(context, program))
        {
            return context->isProgram(program);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbuffer(GLuint renderbuffer)
{
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsRenderbuffer>(renderbuffer);

        if (context->skipValidation() || ValidateIsRenderbuffer(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsShader(GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsShader>(shader);

        if (context->skipValidation() || ValidateIsShader(context, shader))
        {
            return context->isShader(shader);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
}

void GL_APIENTRY LinkProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LinkProgram>(program);

        if (context->skipValidation() || ValidateLinkProgram(context, program))
        {
            context->linkProgram(program);
        }
    }
}

void GL_APIENTRY ReleaseShaderCompiler()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ReleaseShaderCompiler>();

        if (context->skipValidation() || ValidateReleaseShaderCompiler(context))
        {
            context->releaseShaderCompiler();
        }
    }
}

void GL_APIENTRY RenderbufferStorage(GLenum target,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::RenderbufferStorage>(target, internalformat, width,
                                                               height);

        if (context->skipValidation() ||
            ValidateRenderbufferStorage(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

void GL_APIENTRY ShaderBinary(GLsizei count,
                              const GLuint *shaders,
                              GLenum binaryformat,
                              const void *binary,
                              GLsizei length)
{
    EVENT(
        "(GLsizei count = %d, const GLuint *shaders = 0x%0.8p, GLenum binaryformat = 0x%X, const "
        "void *binary = 0x%0.8p, GLsizei length = %d)",
        count, shaders, binaryformat, binary, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ShaderBinary>(count, shaders, binaryformat, binary,
                                                        length);

        if (context->skipValidation() ||
            ValidateShaderBinary(context, count, shaders, binaryformat, binary, length))
        {
            context->shaderBinary(count, shaders, binaryformat, binary, length);
        }
    }
}

void GL_APIENTRY ShaderSource(GLuint shader,
                              GLsizei count,
                              const GLchar *const *string,
                              const GLint *length)
{
    EVENT(
        "(GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = 0x%0.8p, const "
        "GLint *length = 0x%0.8p)",
        shader, count, string, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ShaderSource>(shader, count, string, length);

        if (context->skipValidation() ||
            ValidateShaderSource(context, shader, count, string, length))
        {
            context->shaderSource(shader, count, string, length);
        }
    }
}

void GL_APIENTRY StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", face, func,
          ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilFuncSeparate>(face, func, ref, mask);

        if (context->skipValidation() ||
            ValidateStencilFuncSeparate(context, face, func, ref, mask))
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMaskSeparate(GLenum face, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLuint mask = %u)", face, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilMaskSeparate>(face, mask);

        if (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask))
        {
            context->stencilMaskSeparate(face, mask);
        }
    }
}

void GL_APIENTRY StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    EVENT("(GLenum face = 0x%X, GLenum sfail = 0x%X, GLenum dpfail = 0x%X, GLenum dppass = 0x%X)",
          face, sfail, dpfail, dppass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilOpSeparate>(face, sfail, dpfail, dppass);

        if (context->skipValidation() ||
            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass))
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
    }
}

void GL_APIENTRY Uniform1f(GLint location, GLfloat v0)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform1f>(location, v0);

        if (context->skipValidation() || ValidateUniform1f(context, location, v0))
        {
            context->uniform1f(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform1fv>(location, count, value);

        if (context->skipValidation() || ValidateUniform1fv(context, location, count, value))
        {
            context->uniform1fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform1i(GLint location, GLint v0)
{
    EVENT("(GLint location = %d, GLint v0 = %d)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform1i>(location, v0);

        if (context->skipValidation() || ValidateUniform1i(context, location, v0))
        {
            context->uniform1i(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform1iv>(location, count, value);

        if (context->skipValidation() || ValidateUniform1iv(context, location, count, value))
        {
            context->uniform1iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform2f>(location, v0, v1);

        if (context->skipValidation() || ValidateUniform2f(context, location, v0, v1))
        {
            context->uniform2f(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform2fv>(location, count, value);

        if (context->skipValidation() || ValidateUniform2fv(context, location, count, value))
        {
            context->uniform2fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2i(GLint location, GLint v0, GLint v1)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform2i>(location, v0, v1);

        if (context->skipValidation() || ValidateUniform2i(context, location, v0, v1))
        {
            context->uniform2i(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform2iv>(location, count, value);

        if (context->skipValidation() || ValidateUniform2iv(context, location, count, value))
        {
            context->uniform2iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f)", location, v0,
          v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform3f>(location, v0, v1, v2);

        if (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2))
        {
            context->uniform3f(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform3fv>(location, count, value);

        if (context->skipValidation() || ValidateUniform3fv(context, location, count, value))
        {
            context->uniform3fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)", location, v0, v1,
          v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform3i>(location, v0, v1, v2);

        if (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2))
        {
            context->uniform3i(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform3iv>(location, count, value);

        if (context->skipValidation() || ValidateUniform3iv(context, location, count, value))
        {
            context->uniform3iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    EVENT(
        "(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, GLfloat v3 = %f)",
        location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform4f>(location, v0, v1, v2, v3);

        if (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3))
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform4fv>(location, count, value);

        if (context->skipValidation() || ValidateUniform4fv(context, location, count, value))
        {
            context->uniform4fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint v3 = %d)",
          location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform4i>(location, v0, v1, v2, v3);

        if (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3))
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%0.8p)", location,
          count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Uniform4iv>(location, count, value);

        if (context->skipValidation() || ValidateUniform4iv(context, location, count, value))
        {
            context->uniform4iv(location, count, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%0.8p)",
        location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::UniformMatrix2fv>(location, count, transpose, value);

        if (context->skipValidation() ||
            ValidateUniformMatrix2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%0.8p)",
        location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::UniformMatrix3fv>(location, count, transpose, value);

        if (context->skipValidation() ||
            ValidateUniformMatrix3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4fv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%0.8p)",
        location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::UniformMatrix4fv>(location, count, transpose, value);

        if (context->skipValidation() ||
            ValidateUniformMatrix4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UseProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::UseProgram>(program);

        if (context->skipValidation() || ValidateUseProgram(context, program))
        {
            context->useProgram(program);
        }
    }
}

void GL_APIENTRY ValidateProgram(GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ValidateProgram>(program);

        if (context->skipValidation() || ValidateValidateProgram(context, program))
        {
            context->validateProgram(program);
        }
    }
}

void GL_APIENTRY VertexAttrib1f(GLuint index, GLfloat x)
{
    EVENT("(GLuint index = %u, GLfloat x = %f)", index, x);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib1f>(index, x);

        if (context->skipValidation() || ValidateVertexAttrib1f(context, index, x))
        {
            context->vertexAttrib1f(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%0.8p)", index, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib1fv>(index, v);

        if (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v))
        {
            context->vertexAttrib1fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f)", index, x, y);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib2f>(index, x, y);

        if (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y))
        {
            context->vertexAttrib2f(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%0.8p)", index, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib2fv>(index, v);

        if (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v))
        {
            context->vertexAttrib2fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", index, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib3f>(index, x, y, z);

        if (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z))
        {
            context->vertexAttrib3f(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%0.8p)", index, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib3fv>(index, v);

        if (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v))
        {
            context->vertexAttrib3fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)",
          index, x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib4f>(index, x, y, z, w);

        if (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w))
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%0.8p)", index, v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttrib4fv>(index, v);

        if (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v))
        {
            context->vertexAttrib4fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribPointer(GLuint index,
                                     GLint size,
                                     GLenum type,
                                     GLboolean normalized,
                                     GLsizei stride,
                                     const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        index, size, type, normalized, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttribPointer>(index, size, type, normalized,
                                                               stride, pointer);

        if (context->skipValidation() ||
            ValidateVertexAttribPointer(context, index, size, type, normalized, stride, pointer))
        {
            context->vertexAttribPointer(index, size, type, normalized, stride, pointer);
        }
    }
}
}  // namespace gl
